package com.xforceplus.delivery.cloud.tax.api.janus;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.core.common.listener.ReceiveMsgListener;
import com.xforceplus.core.handle.GlobalReceiveMsgHandle;
import com.xforceplus.delivery.cloud.common.util.TraceUtils;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.springframework.stereotype.Component;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-07-30 15:09
 * @Version: 1.0
 */
@Component
public class JanusCoreReceiveMsgListener extends ReceiveMsgListener {

    public JanusCoreReceiveMsgListener(GlobalReceiveMsgHandle globalReceiveMsgHandle) {
        super(globalReceiveMsgHandle);
    }

    @Trace
    @Override
    public boolean onMessage(SealedMessage sealedMessage) {
        return super.onMessage(sealedMessage);
    }

    @Override
    protected void onReceiveBefore() {
        TraceUtils.setMdcTraceId(TraceUtils.getApmTraceId().orElseGet(TraceUtils::genMdcTraceId));
    }

    @Override
    protected void onReceiveAfter() {
        TraceUtils.clsMdcTraceId();
    }

}
