package com.xforceplus.delivery.cloud.tax.api.janus;

import com.xforceplus.core.handle.IReceiveMsgServiceHandler;
import com.xforceplus.core.handle.ReceiveMsgServiceHandlerFactory;
import com.xforceplus.delivery.cloud.common.client.ExternalRestClient;
import com.xforceplus.delivery.cloud.common.client.InternalRestClient;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.tax.api.properties.JanusCoreProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: 集成平台的消息处理器实现
 * @Author: Hanyongjie
 * @CreateDate: 2020-06-17 12:00
 * @Version: 1.0
 */
@Slf4j
@Component
public class JanusCoreReceiveMsgServiceHandler implements ReceiveMsgServiceHandlerFactory {

    public static final String SVC_PREFIX = "svc://", NET_PREFIX = "http://";

    private Map<String, String> handlers;

    @Autowired
    private InternalRestClient internalRestClient;

    @Autowired
    private ExternalRestClient externalRestClient;

    @Autowired
    private JanusCoreMsgHandler janusCoreMsgHandler;

    public JanusCoreReceiveMsgServiceHandler(JanusCoreProperties janusCoreProperties) {
        this.handlers = janusCoreProperties.getHandlers();
    }

    @Override
    public IReceiveMsgServiceHandler getHandleBean(String messageType) {
        final String sUrl = this.handlers == null ? null : this.handlers.get(messageType);
        if (StringUtils.startWith(sUrl, NET_PREFIX)) {
            return new JanusCoreUrlMsgHandler(sUrl, this.externalRestClient);
        } else if (StringUtils.startWith(sUrl, SVC_PREFIX)) {
            return new JanusCoreSvcMsgHandler(sUrl.substring(SVC_PREFIX.length()), this.internalRestClient);
        } else {
            return this.janusCoreMsgHandler;
        }
    }

}