package com.xforceplus.delivery.cloud.tax.api.janus;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.pool.thread.ApolloThreadInterface;
import com.xforceplus.apollo.pool.thread.ApolloThreadPool;
import com.xforceplus.delivery.cloud.common.util.ReflectUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-09-03 11:31
 * @Version: 1.0
 */
@Slf4j
@Component
public class JanusCoreShutdownListener implements ApplicationListener<ContextClosedEvent> {

    /**
     * Handle an application event.
     * 通过[xforceplus.janus.tcp.open=false]不启动集成平台客户端
     *
     * @param event the event to respond to
     */
    @Override
    public void onApplicationEvent(ContextClosedEvent event) {
        try {
            log.info("MCFactory closing - {}", event);
            Optional.ofNullable(MCFactory.getInstance()).ifPresent(MCFactory::close);
        } catch (Exception e) {
            log.info("MCFactory closed fail - {}", event);
        }
        // 停止时apollo没有停止ResponseThread线程导致线程处于运行状态
        try {
            log.info("ApolloThreadPool closing - {}", event);
            final Optional<Collection<ApolloThreadInterface>> threadGroup = ReflectUtils.fieldValue(ApolloThreadPool.getInstance(), "threadGroup", Map.class).map(Map::values);
            threadGroup.ifPresent(apolloThreadInterfaces -> apolloThreadInterfaces.forEach(t -> {
                if (t != null) {
                    t.stop();
                }
            }));
        } catch (Exception e) {
            log.debug("ApolloThreadPool stop fail - {}", event, e);
        }
    }

}
