package com.xforceplus.delivery.cloud.tax.api.janus;

import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.handle.IReceiveMsgServiceHandler;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.common.client.IRestClient;
import com.xforceplus.delivery.cloud.tax.api.common.ApiResult;

import java.util.Map;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-09-17 14:46
 * @Version: 1.0
 */
public class JanusCoreUrlMsgHandler implements IReceiveMsgServiceHandler {

    String url;
    IRestClient iRestClient;

    public JanusCoreUrlMsgHandler(String url, IRestClient iRestClient) {
        this.url = url;
        this.iRestClient = iRestClient;
    }

    @Override
    public JsonResult process(SealedRecMessage sealedRecMessage) {
        Map<String, String> othersMap = sealedRecMessage.getHeader().getOthers();
        if (othersMap == null || othersMap.isEmpty()) {
            return JsonResult.error("The others is empty");
        }
        final ViewResult<ViewResult> viewResult = iRestClient.postForObject(this.url, sealedRecMessage, ViewResult.class);
        if (viewResult.isOk()) {
            return ApiResult.toJsonResult(viewResult.getData());
        }
        return ApiResult.toJsonResult(viewResult);
    }

}