package com.xforceplus.delivery.cloud.tax.api.janus;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.stereotype.Component;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: 集成平台消息监听器
 * @Author: Hanyongjie
 * @CreateDate: 2020-07-11 19:03
 * @Version: 1.0
 */
@Component
public class SealedRecMessageListener implements ApplicationListener<PayloadApplicationEvent<com.xforceplus.core.common.domain.SealedRecMessage>> {

    @Autowired
    private SealedRecMessageDispatcher sealedRecMessageDispatcher;

    @Override
    public void onApplicationEvent(PayloadApplicationEvent<com.xforceplus.core.common.domain.SealedRecMessage> event) {
        this.sealedRecMessageDispatcher.dispatchSealedRecMessage(event.getPayload());
    }

}
