package com.xforceplus.delivery.cloud.tax.api.logging;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-09-03 21:46
 * @Version: 1.0
 */

import com.xforceplus.delivery.cloud.tax.api.constants.AopOperationEnum.OperateType;

import java.lang.annotation.*;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface AopOperation {

    /**
     * 执行唯一标识
     *
     * @return
     */
    String invokeIdentifier() default "";

    /**
     * 关键字
     *
     * @return
     */
    String keyword() default "";

    /**
     * 业务类型
     *
     * @return
     */
    String businessTypeCode() default "";

    /**
     * 业务key
     *
     * @return
     */
    String businessKey() default "";

    /**
     * 操作类型
     */
    OperateType operateType();

    /**
     * 操作状态
     */
    String operateState() default "";

    /**
     * 操作备注
     */
    String operateRemark() default "";

    /**
     * 返回值
     */
    String returnValue() default "";

}
