package com.xforceplus.delivery.cloud.tax.api.logging;

import com.xforceplus.delivery.cloud.common.api.DataDict;
import com.xforceplus.delivery.cloud.common.api.GlobalResult;
import com.xforceplus.delivery.cloud.common.component.DataDictCache;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.tax.api.entity.BusinessOperate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-10-22 11:47
 * @Version: 1.0
 */
@Slf4j
@Component
public class AopOperationActuator {

    public static final ThreadLocal<BusinessOperate> OPERATE = new ThreadLocal<>();

    @Autowired
    private AopOperationBeanPostProcessor aopOperationBeanPostProcessor;

    /**
     * 执行操作记录
     *
     * @param businessOperate
     * @return
     */
    public GlobalResult executeOperate(BusinessOperate businessOperate) {
        try {
            OPERATE.set(businessOperate);
            return this.aopOperationBeanPostProcessor.invokeForJson(this.getInvokeIdentifier(businessOperate), businessOperate.getArguments());
        } finally {
            OPERATE.remove();
        }
    }

    private String getInvokeIdentifier(BusinessOperate businessOperate) {
        String invokeIdentifier = businessOperate.getInvokeIdentifier();
        if (StringUtils.isNotBlank(invokeIdentifier)) {
            return invokeIdentifier;
        }
        final String businessType = businessOperate.getBusinessType();
        final Optional<DataDict> optDataDict = DataDictCache.getInstance().getDictItemByValue("BUSINESS_OPERATION_TYPE", businessType);
        return optDataDict.map(DataDict::getCode).orElse(businessType) + "$" + businessOperate.getOperateType();
    }

}