package com.xforceplus.delivery.cloud.tax.api.logging;

import com.xforceplus.core.common.utils.ApolloClientUtils;
import com.xforceplus.delivery.cloud.common.component.MyMethodAnnotationBeanPostProcessor;
import com.xforceplus.delivery.cloud.common.util.ReflectUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.tax.api.constants.AopOperationEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-10-22 11:20
 * @Version: 1.0
 */
@Slf4j
@Component
public class AopOperationBeanPostProcessor extends MyMethodAnnotationBeanPostProcessor<AopOperation> {

    public AopOperationBeanPostProcessor() {
        super(AopOperation.class);
    }

    @Override
    protected String getIdentifier(String beanName, Method method, AopOperation annotation) {
        String invokeIdentifier = annotation.invokeIdentifier();
        if (StringUtils.isBlank(invokeIdentifier)) {
            invokeIdentifier = annotation.businessTypeCode() + "$" + annotation.operateType().getType();
        }
        return invokeIdentifier;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ApolloClientUtils) {
            ReflectUtils.doWithMethods(bean.getClass(), method -> {
                switch (method.getName()) {
                    case "sendMsg":
                        // 拦截往集成平台发送HTTP请求的方法
                        this.getMethods().put(AopOperationEnum.InvokeIdentifier.JANUS_HTTP, method);
                        this.getTargets().put(AopOperationEnum.InvokeIdentifier.JANUS_HTTP, bean);
                        break;
                    case "sendHttpMsg":
                        // 拦截往集成平台发送POST请求的方法
                        this.getMethods().put(AopOperationEnum.InvokeIdentifier.JANUS_HTTP_POST, method);
                        this.getTargets().put(AopOperationEnum.InvokeIdentifier.JANUS_HTTP_POST, bean);
                        break;
                    case "sendHttpGetMsg":
                        // 拦截往集成平台发送GET请求的方法
                        this.getMethods().put(AopOperationEnum.InvokeIdentifier.JANUS_HTTP_GET, method);
                        this.getTargets().put(AopOperationEnum.InvokeIdentifier.JANUS_HTTP_GET, bean);
                        break;
                }
            });
            return bean;
        } else {
            return super.postProcessAfterInitialization(bean, beanName);
        }
    }

}