package com.xforceplus.delivery.cloud.tax.api.logging;

import com.xforceplus.delivery.cloud.tax.api.entity.BusinessOperate;
import com.xforceplus.delivery.cloud.tax.api.service.IBusinessOperateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-09-04 01:26
 * @Version: 1.0
 */
@Slf4j
@Component
public class AopOperationConsumer implements Runnable, ApplicationRunner, DisposableBean, Observer {

    private Thread thread;

    private final int batchSize = 30;

    private final BlockingQueue<BusinessOperate> blockingQueue;

    private final List<BusinessOperate> businessOperates = new ArrayList<>(batchSize);

    @Autowired
    private IBusinessOperateService iBusinessOperateService;

    public AopOperationConsumer() {
        this.blockingQueue = new LinkedBlockingQueue<>();
        this.thread = new Thread(this, "aop-opera-consumer");
    }

    /**
     * Invoked by the containing {@code BeanFactory} on destruction of a bean.
     *
     * @throws Exception in case of shutdown errors. Exceptions will get logged
     *                   but not rethrown to allow other beans to release their resources as well.
     */
    @Override
    public void destroy() throws Exception {
        this.thread.interrupt();
    }

    /**
     * When an object implementing interface <code>Runnable</code> is used
     * to create a thread, starting the thread causes the object's
     * <code>run</code> method to be called in that separately executing
     * thread.
     * <p>
     * The general contract of the method <code>run</code> is that it may
     * take any action whatsoever.
     *
     * @see Thread#run()
     */
    @Override
    public void run() {
        while (!this.thread.isInterrupted()) {
            try {
                this.checkAndSave();
            } catch (Exception e) {
                log.warn("Check and saving operate failure", e);
            }
        }
    }

    private void checkAndSave() throws InterruptedException {
        int size = 0;
        this.businessOperates.clear();
        while (size < this.batchSize) {
            BusinessOperate businessOperate = this.blockingQueue.poll(200, TimeUnit.MILLISECONDS);//从队列中取出一个
            if (businessOperate == null) {
                break;
            }
            businessOperates.add(businessOperate);
            size++;
        }
        if (!businessOperates.isEmpty()) {
            this.iBusinessOperateService.saveBatch(this.businessOperates);
        }
    }

    /**
     * Callback used to run the bean.
     *
     * @param args incoming application arguments
     * @throws Exception on error
     */
    @Override
    public void run(ApplicationArguments args) throws Exception {
        this.thread.start();
    }

    /**
     * This method is called whenever the observed object is changed. An
     * application calls an <tt>Observable</tt> object's
     * <code>notifyObservers</code> method to have all the object's
     * observers notified of the change.
     *
     * @param o   the observable object.
     * @param arg an argument passed to the <code>notifyObservers</code>
     */
    @Override
    public void update(Observable o, Object arg) {
        this.blockingQueue.add((BusinessOperate) arg);
    }

}
