package com.xforceplus.delivery.cloud.tax.api.logging;

import ch.qos.logback.core.spi.FilterReply;
import com.xforceplus.core.common.constan.GlobalConstant2;
import com.xforceplus.core.common.utils.DBMarkerUtils;
import com.xforceplus.delivery.cloud.logging.logback.AsyncLogging;
import com.xforceplus.delivery.cloud.logging.logback.AsyncLoggingEventHandler;
import com.xforceplus.delivery.cloud.logging.logback.filter.AsyncLoggingEventFilterCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-08-29 23:47
 * @Version: 1.0
 */
@Configuration
public class LogMarkerCustomizer {

    @Bean
    public AsyncLoggingEventFilterCustomizer dbAsyncLoggingEventFilterCustomizer() {
        return (iLoggingEvent) -> iLoggingEvent.getMarker().getName().contains(DBMarkerUtils.BASE_MARKER_NAME) ? FilterReply.NEUTRAL : FilterReply.DENY;
    }

    @Bean
    @Order(Ordered.HIGHEST_PRECEDENCE + 160)
    public AsyncLoggingEventHandler.Customizer dbAsyncLoggingEventHandlerCustomizer() {
        return (iLoggingEvent, customized) -> {
            if (customized instanceof AsyncLogging) {
                AsyncLogging asyncLogging = (AsyncLogging) customized;
                asyncLogging.setTraceId(iLoggingEvent.getMDCPropertyMap().get(GlobalConstant2.MDC_NETTY_MSG));
                asyncLogging.setMarkerName(iLoggingEvent.getMarker().getName().replace(DBMarkerUtils.BASE_MARKER_NAME, ""));
            }
            return customized;
        };
    }

}
