package com.xforceplus.delivery.cloud.tax.api.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.xforceplus.delivery.cloud.common.api.GlobalResult;
import com.xforceplus.delivery.cloud.tax.api.entity.DispatchRetryQueue;

/**
 * <p>
 * 分发重试队列 服务类
 * </p>
 *
 * @author Hanyongjie
 * @since 2020-07-26
 */
public interface IDispatchRetryQueueService extends IService<DispatchRetryQueue> {

    /**
     * 更新计数器
     *
     * @param dispatchRetryQueue
     */
    void updateCounter(DispatchRetryQueue dispatchRetryQueue);

    /**
     * 新事务执行Wrapper
     *
     * @param lambdaQuery
     */
    boolean removeByWrapper(LambdaQueryWrapper<DispatchRetryQueue> lambdaQuery);

    /**
     * 通过ID/服务/事件/关键字的组合删除(ID优先)
     *
     * @param dispatchRetryQueue
     * @return
     */
    GlobalResult removeByExample(DispatchRetryQueue dispatchRetryQueue);

}
