package com.xforceplus.delivery.cloud.tax.api.service;

import com.google.common.collect.ImmutableMap;
import org.slf4j.MDC;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * 高于生活，源于生活
 * ISealedMessageCallback
 *
 * @Author: Hanyongjie
 * @CreateDate: 2020-12-23 11:16
 * @Version: 1.0
 */
public interface ISealedMessageCallback {

    /**
     * MDC的KEY前缀
     */
    String ACK_PREFIX = "ack.sealed.";

    /**
     * ACK的Keys
     */
    Map<String, String> ACK_MAPS = ImmutableMap.of(
            "payLoadId", "msgId",
            "sourceMsgId", "msgId",
            "sourceRequestName", "requestName",
            "sourceUserId", "userId");

    /**
     * 发送确认消息到集成平台(从上下文获取)
     *
     * @param result
     * @param message
     */
    default void ack(boolean result, String message) {
        Map<String, String> ackMsg = new HashMap<>(ACK_MAPS.size());
        for (String key : ACK_MAPS.keySet()) {
            Optional.ofNullable(MDC.get(ACK_PREFIX + key)).ifPresent(val -> ackMsg.put(key, val));
        }
        this.ack(ackMsg, result, message);
    }

    /**
     * 发送确认消息到集成平台
     * <p>
     * 查询路径为：
     * GATEWAY -》监控管理 -》监控履历
     * BUSINESS -》消息管理 -》消息查询
     * BUSINESS -》日志审计 -》LOG查看
     *
     * @param ackMsg
     * @param result
     * @param message
     */
    void ack(Map<String, String> ackMsg, boolean result, String message);

}
