package com.xforceplus.delivery.cloud.tax.api.service.impl;

import com.xforceplus.delivery.cloud.tax.api.service.IDataDispatchService;
import com.xforceplus.delivery.cloud.tax.api.support.DataDispatchExecutor;
import com.xforceplus.delivery.cloud.transaction.TransactionEventPublisher;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-07-27 15:04
 * @Version: 1.0
 */
@Slf4j
@Service
public class DataDispatchServiceImpl implements IDataDispatchService {

    @Autowired
    private TransactionEventPublisher transactionEventPublisher;

    @Autowired
    private DataDispatchExecutor dataDispatchExecutor;

    /**
     * 分发事件
     *
     * @param eventName
     * @param args
     */
    @Override
    public void doDispatch(String eventName, String keyword, Object... args) {
        this.transactionEventPublisher.callAfterCommitAsync(() -> this.dataDispatchExecutor.doDispatch(eventName, keyword, args));
    }

}