package com.xforceplus.delivery.cloud.tax.api.service.impl;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.client.netty.NettyTCPClient;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.delivery.cloud.tax.api.service.ISealedMessageCallback;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;

/**
 * 高于生活，源于生活
 * MessageCallback
 *
 * @Author: Hanyongjie
 * @CreateDate: 2020-12-21 09:36
 * @Version: 1.0
 */
@Slf4j
@Component
public class SealedMessageCallbackImpl implements ISealedMessageCallback {

    @Override
    public void ack(Map<String, String> ack, boolean result, String message) {
        this.buildAck(ack, result, message).ifPresent(MCFactory.getInstance()::sendMessage);
    }

    /**
     * SealedMessageBuilder.buildReceiptMessage
     *
     * @param ack
     * @return
     */
    protected Optional<SealedMessage> buildAck(Map<String, String> ack, boolean result, String message) {
        final String userId = NettyTCPClient.getInstance().getUserId();
        if (StringUtils.isBlank(userId)) {
            return Optional.empty();
        } else {
            ack.put("zt", result + "");
            ack.put("others_destinations", "[\"" + ack.get("sourceUserId") + "\"]");
            SealedMessage.Header header = new SealedMessage.Header(userId, "request_receipt", ack);
            SealedMessage.Payload payload = new SealedMessage.Payload(message);
            log.debug("Sealed message callback:{}:{} -> {}", result, ack.get("sourceMsgId"), message);
            return Optional.of(new SealedMessage(header, payload));
        }
    }

}