package com.xforceplus.delivery.cloud.tax.api.support;

import com.xforceplus.delivery.cloud.common.util.JsonUtils;
import com.xforceplus.delivery.cloud.common.util.SpringUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.common.util.TraceUtils;
import com.xforceplus.delivery.cloud.tax.api.entity.DispatchRetryQueue;
import com.xforceplus.delivery.cloud.tax.api.service.IDispatchRetryQueueService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.StringJoiner;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: 分发重试器
 * @Author: Hanyongjie
 * @CreateDate: 2020-07-26 21:43
 * @Version: 1.0
 */
@Slf4j
@Component
public class DataDispatchRetryer {

    @Autowired
    private IDispatchRetryQueueService iDispatchRetryQueueService;

    /**
     * 分发数据
     *
     * @param evt  事件名
     * @param key  任务键
     * @param spel 执行器SpEL
     * @param args 执行参数
     */
    public void dispatch(String evt, String key, Object... args) {
        key = StringUtils.toUpperCase(key);
        DispatchRetryQueue dispatchRetryQueue = new DispatchRetryQueue();
        dispatchRetryQueue.setArgs(JsonUtils.toJson(args));
        dispatchRetryQueue.setCounter(0);
        dispatchRetryQueue.setEvtname(evt);
        dispatchRetryQueue.setKeyword(key);
        dispatchRetryQueue.setSvc(SpringUtils.getAppName());
        TraceUtils.getTraceId().ifPresent(dispatchRetryQueue::setTraceId);
        //
        if (this.iDispatchRetryQueueService.lambdaUpdate()
                .set(DispatchRetryQueue::getArgs, dispatchRetryQueue.getArgs())
                .set(DispatchRetryQueue::getCounter, dispatchRetryQueue.getCounter())
                .eq(DispatchRetryQueue::getKeyword, key)
                .update()
        ) {
            log.debug("The updated dispatch queue[{},{}]", evt, key);
            return;
        }
        final boolean affectedRows = this.iDispatchRetryQueueService.save(dispatchRetryQueue);
        log.debug("The added dispatch queue[{},{}],affected rows:{}", evt, key, affectedRows);
    }

    /**
     * 分发数据
     *
     * @param evt  事件名
     * @param key  任务键
     * @param args 执行参数
     */
    public void dispatch(String evt, Serializable key, Object... args) {
        this.dispatch(evt, key.toString(), args);
    }

    /**
     * 分发数据
     *
     * @param evt  事件名
     * @param keys 任务键
     * @param args 执行参数
     */
    public void dispatch(String evt, Serializable[] keys, Object... args) {
        StringJoiner joiner = new StringJoiner("$");
        for (Serializable key : keys) {
            joiner.add(key.toString());
        }
        this.dispatch(evt, joiner.toString(), args);
    }

}