package com.xforceplus.staticmodedemo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.staticmodedemo.entity.ABo;
import com.xforceplus.staticmodedemo.service.IABoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-05-29
 */
@RestController
public class ABoController {

  @Autowired
  private IABoService ABoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aBo ${table.comment}
   * @return
   */
  @GetMapping("/abos" )
  public XfR getABos(XfPage page, ABo aBo) {
    return XfR.ok(ABoServiceImpl.page(page, Wrappers.query(aBo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/abos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ABoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param aBo ${table.comment}
   * @return XfR
   */
  @PostMapping("/abos")
  public XfR save(@RequestBody ABo aBo) {
     return XfR.ok(ABoServiceImpl.save(aBo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param aBo ${table.comment}
   * @return XfR
   */
  @PutMapping("/abos/{id}")
  public XfR putUpdate(@RequestBody ABo aBo,@PathVariable Long id) {
      aBo.setId(id);
      return XfR.ok(ABoServiceImpl.updateById(aBo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param aBo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/abos/{id}")
  public XfR patchUpdate(@RequestBody ABo aBo,@PathVariable Long id) {
      ABo upaBo = ABoServiceImpl.getById(id);
      if(upaBo != null){
        upaBo = ObjectCopyUtils.copyProperties(aBo,upaBo,true);
      }
      return XfR.ok(ABoServiceImpl.updateById(upaBo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/abos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ABoServiceImpl.removeById(id));
  }

  @PostMapping("/abos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "abo");
      params.put("request", condition);

     return XfR.ok(ABoServiceImpl.querys(params));
  }

}
