package com.xforceplus.staticmodedemo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.staticmodedemo.entity.BBo;
import com.xforceplus.staticmodedemo.service.IBBoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-05-29
 */
@RestController
public class BBoController {

  @Autowired
  private IBBoService BBoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bBo ${table.comment}
   * @return
   */
  @GetMapping("/bbos" )
  public XfR getBBos(XfPage page, BBo bBo) {
    return XfR.ok(BBoServiceImpl.page(page, Wrappers.query(bBo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bbos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(BBoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bBo ${table.comment}
   * @return XfR
   */
  @PostMapping("/bbos")
  public XfR save(@RequestBody BBo bBo) {
     return XfR.ok(BBoServiceImpl.save(bBo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bBo ${table.comment}
   * @return XfR
   */
  @PutMapping("/bbos/{id}")
  public XfR putUpdate(@RequestBody BBo bBo,@PathVariable Long id) {
      bBo.setId(id);
      return XfR.ok(BBoServiceImpl.updateById(bBo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bBo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bbos/{id}")
  public XfR patchUpdate(@RequestBody BBo bBo,@PathVariable Long id) {
      BBo upbBo = BBoServiceImpl.getById(id);
      if(upbBo != null){
        upbBo = ObjectCopyUtils.copyProperties(bBo,upbBo,true);
      }
      return XfR.ok(BBoServiceImpl.updateById(upbBo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bbos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(BBoServiceImpl.removeById(id));
  }

  @PostMapping("/bbos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "bbo");
      params.put("request", condition);

     return XfR.ok(BBoServiceImpl.querys(params));
  }

}
