package com.xforceplus.staticmodedemo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.staticmodedemo.entity.CBo;
import com.xforceplus.staticmodedemo.service.ICBoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-05-29
 */
@RestController
public class CBoController {

  @Autowired
  private ICBoService CBoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cBo ${table.comment}
   * @return
   */
  @GetMapping("/cbos" )
  public XfR getCBos(XfPage page, CBo cBo) {
    return XfR.ok(CBoServiceImpl.page(page, Wrappers.query(cBo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/cbos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(CBoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param cBo ${table.comment}
   * @return XfR
   */
  @PostMapping("/cbos")
  public XfR save(@RequestBody CBo cBo) {
     return XfR.ok(CBoServiceImpl.save(cBo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param cBo ${table.comment}
   * @return XfR
   */
  @PutMapping("/cbos/{id}")
  public XfR putUpdate(@RequestBody CBo cBo,@PathVariable Long id) {
      cBo.setId(id);
      return XfR.ok(CBoServiceImpl.updateById(cBo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param cBo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/cbos/{id}")
  public XfR patchUpdate(@RequestBody CBo cBo,@PathVariable Long id) {
      CBo upcBo = CBoServiceImpl.getById(id);
      if(upcBo != null){
        upcBo = ObjectCopyUtils.copyProperties(cBo,upcBo,true);
      }
      return XfR.ok(CBoServiceImpl.updateById(upcBo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cbos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(CBoServiceImpl.removeById(id));
  }

  @PostMapping("/cbos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "cbo");
      params.put("request", condition);

     return XfR.ok(CBoServiceImpl.querys(params));
  }

}
