package com.xforceplus.demoultraman.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-09-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.InvoiceItemSummary;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "demoultraman")
public interface InvoiceItemSummaryFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceItemSummary/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param invoiceItemSummary ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceItemSummary/add")
  public R save(@RequestBody InvoiceItemSummary invoiceItemSummary);

  /**
   * 修改${table.comment}
   * @param invoiceItemSummary ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceItemSummary/update")
  public R updateById(@RequestBody InvoiceItemSummary invoiceItemSummary);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceItemSummary/del/{id}" )
  public R removeById(@PathVariable Long id);

}