package com.xforceplus.demoultraman.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-09-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.InvoiceSummary;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "demoultraman")
public interface InvoiceSummaryFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceSummary/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param invoiceSummary ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceSummary/add")
  public R save(@RequestBody InvoiceSummary invoiceSummary);

  /**
   * 修改${table.comment}
   * @param invoiceSummary ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceSummary/update")
  public R updateById(@RequestBody InvoiceSummary invoiceSummary);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceSummary/del/{id}" )
  public R removeById(@PathVariable Long id);

}