package com.xforceplus.demoultraman.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.CompanyObjectDemo;
import com.xforceplus.demoultraman.service.ICompanyObjectDemoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-20
 */
@RestController
public class CompanyObjectDemoController {

  @Autowired
  private ICompanyObjectDemoService companyObjectDemoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param companyObjectDemo ${table.comment}
   * @return
   */
  @GetMapping("/companyobjectdemos" )
  public XfR getCompanyObjectDemos(XfPage page, CompanyObjectDemo companyObjectDemo) {
    return XfR.ok(companyObjectDemoServiceImpl.page(page, Wrappers.query(companyObjectDemo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/companyobjectdemos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(companyObjectDemoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param companyObjectDemo ${table.comment}
   * @return XfR
   */
  @PostMapping("/companyobjectdemos")
  public XfR save(@RequestBody CompanyObjectDemo companyObjectDemo) {
     return XfR.ok(companyObjectDemoServiceImpl.save(companyObjectDemo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param companyObjectDemo ${table.comment}
   * @return XfR
   */
  @PutMapping("/companyobjectdemos/{id}")
  public XfR putUpdate(@RequestBody CompanyObjectDemo companyObjectDemo,@PathVariable Long id) {
      companyObjectDemo.setId(id);
      return XfR.ok(companyObjectDemoServiceImpl.updateById(companyObjectDemo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param companyObjectDemo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/companyobjectdemos/{id}")
  public XfR patchUpdate(@RequestBody CompanyObjectDemo companyObjectDemo,@PathVariable Long id) {
      CompanyObjectDemo upcompanyObjectDemo = companyObjectDemoServiceImpl.getById(id);
      if(upcompanyObjectDemo != null){
        upcompanyObjectDemo = ObjectCopyUtils.copyProperties(companyObjectDemo,upcompanyObjectDemo,true);
      }
      return XfR.ok(companyObjectDemoServiceImpl.updateById(upcompanyObjectDemo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/companyobjectdemos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(companyObjectDemoServiceImpl.removeById(id));
  }

  @PostMapping("/companyobjectdemos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "company_object_demo");
     params.put("request", condition);

     return XfR.ok(companyObjectDemoServiceImpl.querys(params));
  }

}
