package com.xforceplus.demoultraman.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.InvoiceItemSummary;
import com.xforceplus.demoultraman.service.IInvoiceItemSummaryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-20
 */
@RestController
public class InvoiceItemSummaryController {

  @Autowired
  private IInvoiceItemSummaryService invoiceItemSummaryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceItemSummary ${table.comment}
   * @return
   */
  @GetMapping("/invoiceitemsummarys" )
  public XfR getInvoiceItemSummarys(XfPage page, InvoiceItemSummary invoiceItemSummary) {
    return XfR.ok(invoiceItemSummaryServiceImpl.page(page, Wrappers.query(invoiceItemSummary)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceitemsummarys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceItemSummaryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceItemSummary ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceitemsummarys")
  public XfR save(@RequestBody InvoiceItemSummary invoiceItemSummary) {
     return XfR.ok(invoiceItemSummaryServiceImpl.save(invoiceItemSummary));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceItemSummary ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceitemsummarys/{id}")
  public XfR putUpdate(@RequestBody InvoiceItemSummary invoiceItemSummary,@PathVariable Long id) {
      invoiceItemSummary.setId(id);
      return XfR.ok(invoiceItemSummaryServiceImpl.updateById(invoiceItemSummary));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceItemSummary ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceitemsummarys/{id}")
  public XfR patchUpdate(@RequestBody InvoiceItemSummary invoiceItemSummary,@PathVariable Long id) {
      InvoiceItemSummary upinvoiceItemSummary = invoiceItemSummaryServiceImpl.getById(id);
      if(upinvoiceItemSummary != null){
        upinvoiceItemSummary = ObjectCopyUtils.copyProperties(invoiceItemSummary,upinvoiceItemSummary,true);
      }
      return XfR.ok(invoiceItemSummaryServiceImpl.updateById(upinvoiceItemSummary));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceitemsummarys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceItemSummaryServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceitemsummarys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_item_summary");
     params.put("request", condition);

     return XfR.ok(invoiceItemSummaryServiceImpl.querys(params));
  }

}
