package com.xforceplus.demoultraman.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.InvoiceSummary;
import com.xforceplus.demoultraman.service.IInvoiceSummaryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-20
 */
@RestController
public class InvoiceSummaryController {

  @Autowired
  private IInvoiceSummaryService invoiceSummaryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceSummary ${table.comment}
   * @return
   */
  @GetMapping("/invoicesummarys" )
  public XfR getInvoiceSummarys(XfPage page, InvoiceSummary invoiceSummary) {
    return XfR.ok(invoiceSummaryServiceImpl.page(page, Wrappers.query(invoiceSummary)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicesummarys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceSummaryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceSummary ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicesummarys")
  public XfR save(@RequestBody InvoiceSummary invoiceSummary) {
     return XfR.ok(invoiceSummaryServiceImpl.save(invoiceSummary));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceSummary ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicesummarys/{id}")
  public XfR putUpdate(@RequestBody InvoiceSummary invoiceSummary,@PathVariable Long id) {
      invoiceSummary.setId(id);
      return XfR.ok(invoiceSummaryServiceImpl.updateById(invoiceSummary));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceSummary ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicesummarys/{id}")
  public XfR patchUpdate(@RequestBody InvoiceSummary invoiceSummary,@PathVariable Long id) {
      InvoiceSummary upinvoiceSummary = invoiceSummaryServiceImpl.getById(id);
      if(upinvoiceSummary != null){
        upinvoiceSummary = ObjectCopyUtils.copyProperties(invoiceSummary,upinvoiceSummary,true);
      }
      return XfR.ok(invoiceSummaryServiceImpl.updateById(upinvoiceSummary));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicesummarys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceSummaryServiceImpl.removeById(id));
  }

  @PostMapping("/invoicesummarys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_summary");
     params.put("request", condition);

     return XfR.ok(invoiceSummaryServiceImpl.querys(params));
  }

}
