package com.xforceplus.demoultraman.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.NumberTest2;
import com.xforceplus.demoultraman.service.INumberTest2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-20
 */
@RestController
public class NumberTest2Controller {

  @Autowired
  private INumberTest2Service numberTest2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param numberTest2 ${table.comment}
   * @return
   */
  @GetMapping("/numbertest2s" )
  public XfR getNumberTest2s(XfPage page, NumberTest2 numberTest2) {
    return XfR.ok(numberTest2ServiceImpl.page(page, Wrappers.query(numberTest2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/numbertest2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(numberTest2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param numberTest2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/numbertest2s")
  public XfR save(@RequestBody NumberTest2 numberTest2) {
     return XfR.ok(numberTest2ServiceImpl.save(numberTest2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param numberTest2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/numbertest2s/{id}")
  public XfR putUpdate(@RequestBody NumberTest2 numberTest2,@PathVariable Long id) {
      numberTest2.setId(id);
      return XfR.ok(numberTest2ServiceImpl.updateById(numberTest2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param numberTest2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/numbertest2s/{id}")
  public XfR patchUpdate(@RequestBody NumberTest2 numberTest2,@PathVariable Long id) {
      NumberTest2 upnumberTest2 = numberTest2ServiceImpl.getById(id);
      if(upnumberTest2 != null){
        upnumberTest2 = ObjectCopyUtils.copyProperties(numberTest2,upnumberTest2,true);
      }
      return XfR.ok(numberTest2ServiceImpl.updateById(upnumberTest2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/numbertest2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(numberTest2ServiceImpl.removeById(id));
  }

  @PostMapping("/numbertest2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "number_test2");
     params.put("request", condition);

     return XfR.ok(numberTest2ServiceImpl.querys(params));
  }

}
