package com.xforceplus.demoultraman.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.PimInvoiceItem;
import com.xforceplus.demoultraman.service.IPimInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-20
 */
@RestController
public class PimInvoiceItemController {

  @Autowired
  private IPimInvoiceItemService pimInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pimInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/piminvoiceitems" )
  public XfR getPimInvoiceItems(XfPage page, PimInvoiceItem pimInvoiceItem) {
    return XfR.ok(pimInvoiceItemServiceImpl.page(page, Wrappers.query(pimInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/piminvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pimInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pimInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/piminvoiceitems")
  public XfR save(@RequestBody PimInvoiceItem pimInvoiceItem) {
     return XfR.ok(pimInvoiceItemServiceImpl.save(pimInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pimInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/piminvoiceitems/{id}")
  public XfR putUpdate(@RequestBody PimInvoiceItem pimInvoiceItem,@PathVariable Long id) {
      pimInvoiceItem.setId(id);
      return XfR.ok(pimInvoiceItemServiceImpl.updateById(pimInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pimInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/piminvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody PimInvoiceItem pimInvoiceItem,@PathVariable Long id) {
      PimInvoiceItem uppimInvoiceItem = pimInvoiceItemServiceImpl.getById(id);
      if(uppimInvoiceItem != null){
        uppimInvoiceItem = ObjectCopyUtils.copyProperties(pimInvoiceItem,uppimInvoiceItem,true);
      }
      return XfR.ok(pimInvoiceItemServiceImpl.updateById(uppimInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/piminvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pimInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/piminvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pim_invoice_item");
     params.put("request", condition);

     return XfR.ok(pimInvoiceItemServiceImpl.querys(params));
  }

}
