package com.xforceplus.demoultraman.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.PimInvoiceMain;
import com.xforceplus.demoultraman.service.IPimInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-20
 */
@RestController
public class PimInvoiceMainController {

  @Autowired
  private IPimInvoiceMainService pimInvoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pimInvoiceMain ${table.comment}
   * @return
   */
  @GetMapping("/piminvoicemains" )
  public XfR getPimInvoiceMains(XfPage page, PimInvoiceMain pimInvoiceMain) {
    return XfR.ok(pimInvoiceMainServiceImpl.page(page, Wrappers.query(pimInvoiceMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/piminvoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pimInvoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pimInvoiceMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/piminvoicemains")
  public XfR save(@RequestBody PimInvoiceMain pimInvoiceMain) {
     return XfR.ok(pimInvoiceMainServiceImpl.save(pimInvoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pimInvoiceMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/piminvoicemains/{id}")
  public XfR putUpdate(@RequestBody PimInvoiceMain pimInvoiceMain,@PathVariable Long id) {
      pimInvoiceMain.setId(id);
      return XfR.ok(pimInvoiceMainServiceImpl.updateById(pimInvoiceMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pimInvoiceMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/piminvoicemains/{id}")
  public XfR patchUpdate(@RequestBody PimInvoiceMain pimInvoiceMain,@PathVariable Long id) {
      PimInvoiceMain uppimInvoiceMain = pimInvoiceMainServiceImpl.getById(id);
      if(uppimInvoiceMain != null){
        uppimInvoiceMain = ObjectCopyUtils.copyProperties(pimInvoiceMain,uppimInvoiceMain,true);
      }
      return XfR.ok(pimInvoiceMainServiceImpl.updateById(uppimInvoiceMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/piminvoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pimInvoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/piminvoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pim_invoice_main");
     params.put("request", condition);

     return XfR.ok(pimInvoiceMainServiceImpl.querys(params));
  }

}
