package com.xforceplus.demoultraman.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.StandardInvoice;
import com.xforceplus.demoultraman.service.IStandardInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-20
 */
@RestController
public class StandardInvoiceController {

  @Autowired
  private IStandardInvoiceService standardInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param standardInvoice ${table.comment}
   * @return
   */
  @GetMapping("/standardinvoices" )
  public XfR getStandardInvoices(XfPage page, StandardInvoice standardInvoice) {
    return XfR.ok(standardInvoiceServiceImpl.page(page, Wrappers.query(standardInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/standardinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(standardInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param standardInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/standardinvoices")
  public XfR save(@RequestBody StandardInvoice standardInvoice) {
     return XfR.ok(standardInvoiceServiceImpl.save(standardInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param standardInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/standardinvoices/{id}")
  public XfR putUpdate(@RequestBody StandardInvoice standardInvoice,@PathVariable Long id) {
      standardInvoice.setId(id);
      return XfR.ok(standardInvoiceServiceImpl.updateById(standardInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param standardInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/standardinvoices/{id}")
  public XfR patchUpdate(@RequestBody StandardInvoice standardInvoice,@PathVariable Long id) {
      StandardInvoice upstandardInvoice = standardInvoiceServiceImpl.getById(id);
      if(upstandardInvoice != null){
        upstandardInvoice = ObjectCopyUtils.copyProperties(standardInvoice,upstandardInvoice,true);
      }
      return XfR.ok(standardInvoiceServiceImpl.updateById(upstandardInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/standardinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(standardInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/standardinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "standard_invoice");
     params.put("request", condition);

     return XfR.ok(standardInvoiceServiceImpl.querys(params));
  }

}
