package com.xforceplus.demoultraman.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.StandardInvoiceItem;
import com.xforceplus.demoultraman.service.IStandardInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-20
 */
@RestController
public class StandardInvoiceItemController {

  @Autowired
  private IStandardInvoiceItemService standardInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param standardInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/standardinvoiceitems" )
  public XfR getStandardInvoiceItems(XfPage page, StandardInvoiceItem standardInvoiceItem) {
    return XfR.ok(standardInvoiceItemServiceImpl.page(page, Wrappers.query(standardInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/standardinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(standardInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param standardInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/standardinvoiceitems")
  public XfR save(@RequestBody StandardInvoiceItem standardInvoiceItem) {
     return XfR.ok(standardInvoiceItemServiceImpl.save(standardInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param standardInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/standardinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody StandardInvoiceItem standardInvoiceItem,@PathVariable Long id) {
      standardInvoiceItem.setId(id);
      return XfR.ok(standardInvoiceItemServiceImpl.updateById(standardInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param standardInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/standardinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody StandardInvoiceItem standardInvoiceItem,@PathVariable Long id) {
      StandardInvoiceItem upstandardInvoiceItem = standardInvoiceItemServiceImpl.getById(id);
      if(upstandardInvoiceItem != null){
        upstandardInvoiceItem = ObjectCopyUtils.copyProperties(standardInvoiceItem,upstandardInvoiceItem,true);
      }
      return XfR.ok(standardInvoiceItemServiceImpl.updateById(upstandardInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/standardinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(standardInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/standardinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "standard_invoice_item");
     params.put("request", condition);

     return XfR.ok(standardInvoiceItemServiceImpl.querys(params));
  }

}
