package com.xforceplus.demoultraman.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.demoultraman.entity.TenantObjectDemo;
import com.xforceplus.demoultraman.service.ITenantObjectDemoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-20
 */
@RestController
public class TenantObjectDemoController {

  @Autowired
  private ITenantObjectDemoService tenantObjectDemoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tenantObjectDemo ${table.comment}
   * @return
   */
  @GetMapping("/tenantobjectdemos" )
  public XfR getTenantObjectDemos(XfPage page, TenantObjectDemo tenantObjectDemo) {
    return XfR.ok(tenantObjectDemoServiceImpl.page(page, Wrappers.query(tenantObjectDemo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tenantobjectdemos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tenantObjectDemoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tenantObjectDemo ${table.comment}
   * @return XfR
   */
  @PostMapping("/tenantobjectdemos")
  public XfR save(@RequestBody TenantObjectDemo tenantObjectDemo) {
     return XfR.ok(tenantObjectDemoServiceImpl.save(tenantObjectDemo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tenantObjectDemo ${table.comment}
   * @return XfR
   */
  @PutMapping("/tenantobjectdemos/{id}")
  public XfR putUpdate(@RequestBody TenantObjectDemo tenantObjectDemo,@PathVariable Long id) {
      tenantObjectDemo.setId(id);
      return XfR.ok(tenantObjectDemoServiceImpl.updateById(tenantObjectDemo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tenantObjectDemo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tenantobjectdemos/{id}")
  public XfR patchUpdate(@RequestBody TenantObjectDemo tenantObjectDemo,@PathVariable Long id) {
      TenantObjectDemo uptenantObjectDemo = tenantObjectDemoServiceImpl.getById(id);
      if(uptenantObjectDemo != null){
        uptenantObjectDemo = ObjectCopyUtils.copyProperties(tenantObjectDemo,uptenantObjectDemo,true);
      }
      return XfR.ok(tenantObjectDemoServiceImpl.updateById(uptenantObjectDemo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tenantobjectdemos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tenantObjectDemoServiceImpl.removeById(id));
  }

  @PostMapping("/tenantobjectdemos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tenant_object_demo");
     params.put("request", condition);

     return XfR.ok(tenantObjectDemoServiceImpl.querys(params));
  }

}
