package com.xforceplus.docflow.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.docflow.entity.Docapply;
import com.xforceplus.docflow.service.IDocapplyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-01
 */
@RestController
public class DocapplyController {

  @Autowired
  private IDocapplyService docapplyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param docapply ${table.comment}
   * @return
   */
  @GetMapping("/docapplys" )
  public XfR getDocapplys(XfPage page, Docapply docapply) {
    return XfR.ok(docapplyServiceImpl.page(page, Wrappers.query(docapply)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/docapplys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(docapplyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param docapply ${table.comment}
   * @return XfR
   */
  @PostMapping("/docapplys")
  public XfR save(@RequestBody Docapply docapply) {
     return XfR.ok(docapplyServiceImpl.save(docapply));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param docapply ${table.comment}
   * @return XfR
   */
  @PutMapping("/docapplys/{id}")
  public XfR putUpdate(@RequestBody Docapply docapply,@PathVariable Long id) {
      docapply.setId(id);
      return XfR.ok(docapplyServiceImpl.updateById(docapply));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param docapply ${table.comment}
   * @return XfR
   */
  @PatchMapping("/docapplys/{id}")
  public XfR patchUpdate(@RequestBody Docapply docapply,@PathVariable Long id) {
      Docapply updocapply = docapplyServiceImpl.getById(id);
      if(updocapply != null){
        updocapply = ObjectCopyUtils.copyProperties(docapply,updocapply,true);
      }
      return XfR.ok(docapplyServiceImpl.updateById(updocapply));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/docapplys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(docapplyServiceImpl.removeById(id));
  }

  @PostMapping("/docapplys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "docapply");
     params.put("request", condition);

     return XfR.ok(docapplyServiceImpl.querys(params));
  }

}
