/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.account;

import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.account.LoginCheckUtil;
import com.xforceplus.account.cache.LoginFileCache;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.notice.ExceptionDdNoticer;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.proxy.domain.IpResponse;
import com.xforceplus.utils.HttpRequestUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.util.Map;
import javax.validation.Valid;
import okhttp3.Credentials;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginSys {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoginSys.class);

    public abstract WebClient login(@Valid AccountTemplateDO var1, Map<String, String> var2) throws IOException;

    public WebClient doLogin(@Valid AccountTemplateDO account, Map<String, String> contextMap) throws IOException {
        if (!this.checkLoginParam(account)) {
            return null;
        }
        if (this.needLoginCache(account)) {
            XxlJobLogger.log((String)"\u5f53\u524d\u8d26\u6237\u4e0d\u4f7f\u7528\u767b\u5f55\u7f13\u5b58...", (Object[])new Object[0]);
            return this.login(account, contextMap);
        }
        String siteUrl = account.getSiteUrl().trim();
        String protocolName = HttpRequestUtil.getWebProtocol(siteUrl, "", "http://");
        contextMap.put("protocolName", protocolName);
        WebClient webClient = this.getWebClientCache(account);
        if (webClient != null) {
            if (this.verifyWebClient(this.pushProxy(webClient, account), contextMap)) {
                return webClient;
            }
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u767b\u5f55\u7f13\u5b58\u5931\u8d25,\u91cd\u65b0\u6267\u884c\u767b\u5f55\u64cd\u4f5c...", (Object[])new Object[0]);
            LoginFileCache.getInstance().delLoginCache(account);
            return this.loginSync(account, contextMap);
        }
        XxlJobLogger.log((String)"\u767b\u5f55\u7f13\u5b58\u5931\u6548,\u6267\u884c\u767b\u5f55\u64cd\u4f5c...", (Object[])new Object[0]);
        return this.loginSync(account, contextMap);
    }

    private WebClient loginSync(AccountTemplateDO account, Map<String, String> contextMap) throws IOException {
        return LoginFileCache.getInstance().login(this, account, contextMap);
    }

    public WebClient pushProxy(WebClient webClient, AccountTemplateDO account) {
        if (account.getIpProxy() != null && account.getIpProxy() == 1) {
            IpResponse proxyConfig = ProxyIpFactory.getRemoteIpProxy(account.getAccountId(), account.getProxyArea());
            if (proxyConfig != null && StringUtils.isNotBlank((CharSequence)proxyConfig.getIp()) && StringUtils.isNotBlank((CharSequence)proxyConfig.getPort())) {
                String proxyIp = proxyConfig.getIp();
                String proxyPort = proxyConfig.getPort();
                XxlJobLogger.log((String)"\u767b\u5f55\u4f7f\u7528\u4ee3\u7406IP\u3010{}:{}\u3011\uff01", (Object[])new Object[]{proxyIp, proxyPort});
                webClient.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
                if (StringUtils.isNotBlank((CharSequence)proxyConfig.getBasicProxy())) {
                    webClient.addRequestHeader("Proxy-Authorization", proxyConfig.getBasicProxy());
                }
            } else {
                ExceptionDdNoticer.loggerError(log, "\u672a\u83b7\u53d6\u5230\u4ee3\u7406IP");
            }
        }
        return webClient;
    }

    private boolean checkLoginParam(AccountTemplateDO account) {
        return LoginCheckUtil.check(account);
    }

    private boolean needLoginCache(AccountTemplateDO account) {
        return account.getIsNeedLoginCache() == null || account.getIsNeedLoginCache() != 1;
    }

    private WebClient getWebClientCache(AccountTemplateDO account) {
        return LoginFileCache.getInstance().get(account);
    }

    private void putWebClientCache(AccountTemplateDO account, WebClient webClient) {
        LoginFileCache.getInstance().put(webClient, account);
    }

    protected boolean verifyWebClient(WebClient webClient, Map<String, String> contextMap) {
        return false;
    }

    public static void main(String[] args) {
        System.out.println(Credentials.basic((String)"proxyConfig.getAccount()", (String)"proxyConfig.getPassword())"));
    }
}

