/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.config;

import com.xforceplus.core.enums.SupplierConstantEnum;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.HashMap;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class InitEnviInfo
implements ApplicationRunner {
    private final Logger logger = LoggerFactory.getLogger(InitEnviInfo.class);
    @Autowired
    RedissonLock redissonLock;
    public static Redisson redisson;
    @Value(value="${xxl.job.executor.appname}")
    private String appName;

    public void run(ApplicationArguments args) {
        this.logger.info("initSupplierMap:" + SupplierConstantEnum.getMergeSupplierMap().size());
        try {
            HashMap jobHandlerRegisterInfo = new HashMap();
            if (jobHandlerRegisterInfo.size() != 0) {
                redisson = this.redissonLock.getRedissonManager().getRedisson();
                RBucket keyObject = redisson.getBucket(this.appName);
                if (keyObject.isExists()) {
                    keyObject.delete();
                }
                keyObject.set(jobHandlerRegisterInfo);
                XxlJobLogger.log((String)" DCS @JobHandler map write Redis success\uff01", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"ERRPR! ApplicationRunner.InitEnviInfo,Error Info:{}", (Object[])new Object[]{e.getMessage()});
        }
    }
}

