/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.xforceplus.core.enums.BillsTypeEnum;
import com.xforceplus.core.resolve.DocumentResolverPost;
import com.xforceplus.core.resolve.ResolveTask;
import java.util.Random;

public class DocumentResolverPostImpl
implements DocumentResolverPost {
    private Random random = new Random(System.currentTimeMillis());

    @Override
    public String handle(String result, ResolveTask task) {
        String batchNo = "edcs-" + System.currentTimeMillis() + (this.random.nextInt(899) + 100);
        Object obj = JSON.parse((String)result);
        if (obj instanceof JSONObject) {
            this.addInfo((JSONObject)obj, task, batchNo);
        } else if (obj instanceof JSONArray) {
            JSONArray arr = (JSONArray)obj;
            for (int i = 0; i < arr.size(); ++i) {
                this.addInfo(arr.getJSONObject(i), task, batchNo);
            }
        }
        return JSON.toJSONString((Object)obj);
    }

    private void addInfo(JSONObject object, ResolveTask task, String batchNo) {
        object.put((Object)"collectionAccount", (Object)task.getAccountName());
        BillsTypeEnum billType = task.getJobBillType().getBillType();
        if ((BillsTypeEnum.POS.equals(billType) || BillsTypeEnum.IR.equals(billType)) && !object.containsKey("collectionBatch")) {
            object.put((Object)"collectionBatch", (Object)batchNo);
        }
        object.put((Object)"purchaseRetailerId", (Object)task.getRetailKey());
        object.put((Object)"purchaseRetailerName", (Object)task.getRetailName());
        object.put((Object)"originalFileUrl", (Object)task.getUrl());
    }
}

