/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve;

import com.xforceplus.bean.JobBillTypeBean;
import com.xforceplus.core.resolve.DocumentResolver;
import com.xforceplus.core.resolve.DocumentResolverPost;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.core.resolve.TaskQueueManager;
import com.xforceplus.service.oss.OssService;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import jodd.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskConsumer {
    private static final Logger log = LoggerFactory.getLogger(TaskConsumer.class);
    private final Map<JobBillTypeBean, ThreadBean> threadMap = new HashMap<JobBillTypeBean, ThreadBean>(8);
    @Resource
    private TaskQueueManager taskQueueManager;
    @Autowired
    private DocumentResolver documentResolver;
    @Autowired
    private DocumentResolverPost documentResolverPost;
    @Resource
    private OssService ossService;

    @PostConstruct
    public void init() {
        for (BlockingDeque<ResolveTask> queue : this.taskQueueManager.getQueues()) {
            Thread thread = new Thread(() -> {
                block4: while (true) {
                    try {
                        while (true) {
                            ResolveTask task = (ResolveTask)queue.take();
                            try {
                                this.handle(task);
                                continue block4;
                            }
                            catch (Exception ex) {
                                log.error("\u89e3\u6790\u5f02\u5e38 {}", (Object)ex.getMessage());
                                XxlJobLogger.log((Throwable)ex);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("\u89e3\u6790\u7ebf\u7a0b\u9000\u51fa");
                        return;
                    }
                }
            });
            thread.start();
        }
    }

    private void handle(ResolveTask task) {
        ThreadBean thread = this.threadMap.get(task.getJobBillType());
        if (thread == null) {
            thread = new ThreadBean();
            this.threadMap.put(task.getJobBillType(), thread);
        }
        thread.getThreadPoolExecutor().execute(() -> {
            try {
                if (task.getFilePath().endsWith(".pdf")) {
                    String url = this.ossService.uploadPdf(task);
                    log.info("\u4e0a\u4f20PDF {}", (Object)url);
                    XxlJobLogger.log((String)"\u4e0a\u4f20PDF {}", (Object[])new Object[]{url});
                } else {
                    String content = this.documentResolver.resolve(task);
                    content = this.documentResolverPost.handle(content, task);
                    String url = this.ossService.uploadResolveResult(content, task);
                    log.info("\u4e0a\u4f20\u89e3\u6790\u7ed3\u679c {}", (Object)url);
                    XxlJobLogger.log((String)"\u4e0a\u4f20\u89e3\u6790\u7ed3\u679c {}", (Object[])new Object[]{url});
                }
            }
            catch (Exception ex) {
                log.error("\u6267\u884c\u89e3\u6790\u4efb\u52a1\u5931\u8d25 {}", (Object)ex.getMessage(), (Object)ex);
                XxlJobLogger.log((Throwable)ex);
            }
            finally {
                this.deleteFileQuietly(task.getFilePath());
            }
        });
    }

    private void deleteFileQuietly(String filePath) {
        try {
            new File(filePath).delete();
        }
        catch (Exception ex) {
            log.error("\u5220\u9664\u672c\u5730\u6587\u4ef6\u5931\u8d25 {} {}", (Object)filePath, (Object)ex.getMessage());
        }
    }

    private static class ThreadBean {
        private final Logger logger = LoggerFactory.getLogger(ThreadBean.class);
        private BlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(100);
        private ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, this.workQueue, new ThreadFactoryBuilder().setNameFormat("t-bill-%d").setUncaughtExceptionHandler((t, e) -> this.logger.error("Uncaught exception in thread {}", (Object)t.getName(), (Object)e)).get(), new ThreadPoolExecutor.CallerRunsPolicy());

        public Logger getLogger() {
            return this.logger;
        }

        public BlockingQueue<Runnable> getWorkQueue() {
            return this.workQueue;
        }

        public ThreadPoolExecutor getThreadPoolExecutor() {
            return this.threadPoolExecutor;
        }

        public void setWorkQueue(BlockingQueue<Runnable> workQueue) {
            this.workQueue = workQueue;
        }

        public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
            this.threadPoolExecutor = threadPoolExecutor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadBean)) {
                return false;
            }
            ThreadBean other = (ThreadBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Logger this$logger = this.getLogger();
            Logger other$logger = other.getLogger();
            if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
                return false;
            }
            BlockingQueue<Runnable> this$workQueue = this.getWorkQueue();
            BlockingQueue<Runnable> other$workQueue = other.getWorkQueue();
            if (this$workQueue == null ? other$workQueue != null : !this$workQueue.equals(other$workQueue)) {
                return false;
            }
            ThreadPoolExecutor this$threadPoolExecutor = this.getThreadPoolExecutor();
            ThreadPoolExecutor other$threadPoolExecutor = other.getThreadPoolExecutor();
            return !(this$threadPoolExecutor == null ? other$threadPoolExecutor != null : !this$threadPoolExecutor.equals(other$threadPoolExecutor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadBean;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Logger $logger = this.getLogger();
            result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
            BlockingQueue<Runnable> $workQueue = this.getWorkQueue();
            result = result * 59 + ($workQueue == null ? 43 : $workQueue.hashCode());
            ThreadPoolExecutor $threadPoolExecutor = this.getThreadPoolExecutor();
            result = result * 59 + ($threadPoolExecutor == null ? 43 : $threadPoolExecutor.hashCode());
            return result;
        }

        public String toString() {
            return "TaskConsumer.ThreadBean(logger=" + this.getLogger() + ", workQueue=" + this.getWorkQueue() + ", threadPoolExecutor=" + this.getThreadPoolExecutor() + ")";
        }
    }
}

