/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.service.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.gargoylesoftware.htmlunit.WebClient;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.xforceplus.account.AbstractLoginSys;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.bean.JobBillTypeBean;
import com.xforceplus.core.annotation.DcsJobHandler;
import com.xforceplus.core.notice.ExceptionDdNoticer;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.core.resolve.TaskProducer;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.service.account.AccountService;
import com.xforceplus.service.oss.OssService;
import com.xforceplus.utils.FileUtil;
import com.xforceplus.utils.RedisUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDcsHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseDcsHandler.class);
    @Resource
    private AccountService accountService;
    @Resource
    private OssService ossService;
    @Resource
    private TaskProducer taskProducer;
    @Resource
    private RedissonLock redissonLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String param) throws Exception {
        AccountTemplateDO account;
        String paramStr = param.trim();
        if (paramStr.isEmpty()) {
            XxlJobLogger.log((String)"\u4f9b\u5e94\u5546(\u5ba2\u6237)\u5e73\u53f0\u7b80\u79f0\uff08\u4efb\u52a1\u53c2\u6570\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            return FAIL;
        }
        try {
            JSONObject json = JSON.parseObject((String)paramStr);
            String accountId = json.getString("accountId");
            if (StringUtils.isBlank((CharSequence)accountId)) {
                throw new RuntimeException("accountId\u4e3a\u7a7a");
            }
            json.remove((Object)"accountId");
            account = this.accountService.queryAccount(accountId, json);
            if (account == null) {
                XxlJobLogger.log((String)"\u672a\u83b7\u53d6\u5230\u6307\u5b9a\u8d26\u53f7", (Object[])new Object[0]);
                ExceptionDdNoticer.loggerError(log, "\u672a\u83b7\u53d6\u5230\u6307\u5b9a\u8d26\u53f7 \u8d26\u53f7\u7f16\u53f7: {}", accountId);
                return FAIL;
            }
        }
        catch (Exception ex) {
            XxlJobLogger.log((String)("\u83b7\u53d6\u8d26\u53f7\u5f02\u5e38 " + ex.getMessage()), (Object[])new Object[0]);
            ExceptionDdNoticer.loggerError(log, "\u83b7\u53d6\u8d26\u53f7\u5f02\u5e38 \u4efb\u52a1\u53c2\u6570: {}, {}", paramStr, ex.getMessage());
            return FAIL;
        }
        DcsJobHandler dcsJobHandler = this.getDcsJobHandler();
        account.setBillsType(dcsJobHandler.billType().getKey());
        JobBillTypeBean jobBillType = new JobBillTypeBean(dcsJobHandler.billType(), dcsJobHandler.version());
        boolean lock = false;
        String key = null;
        try {
            int dragTime = account.getDragTime();
            key = RedisUtil.getKey(account);
            lock = this.redissonLock.lock(key, dragTime);
            XxlJobLogger.log((String)"\u91c7\u96c6\u767b\u5f55\u52a0\u9501\uff0cRedissonKey={}, Status={}, lockTime={}/S.", (Object[])new Object[]{key, lock, dragTime});
            if (lock) {
                HashMap contextMap = Maps.newHashMap();
                WebClient webClient = this.getLoginSys().doLogin(account, contextMap);
                if (webClient == null) {
                    XxlJobLogger.log((String)"WebClient \u4e3a\u7a7a\uff0c\u767b\u5f55\u5931\u8d25\uff01", (Object[])new Object[0]);
                    ExceptionDdNoticer.loggerError(log, "\u767b\u5f55\u5931\u8d25 \u8d26\u53f7: {}", account.getAccountName());
                    ReturnT returnT = FAIL;
                    return returnT;
                }
                XxlJobLogger.log((String)"\u5f00\u59cb\u91c7\u96c6", (Object[])new Object[0]);
                List<String> filePathList = this.doCollect(webClient, account, contextMap);
                if (account.isBatchRenameEnable()) {
                    FileUtil.renFile(account);
                }
                XxlJobLogger.log((String)("\u91c7\u96c6\u5b8c\u6bd5 \u6587\u4ef6\u6570\uff1a" + filePathList.size()), (Object[])new Object[0]);
                if (CollectionUtils.isNotEmpty(filePathList)) {
                    for (String filePath : filePathList) {
                        List as;
                        if (StringUtils.isBlank((CharSequence)filePath) || !new File(filePath).exists()) continue;
                        String url = this.ossService.uploadRawFile(filePath, account);
                        ResolveTask resolveTask = new ResolveTask(account, jobBillType, filePath, url);
                        if (filePath.endsWith(".pdf") && CollectionUtils.isNotEmpty((Collection)(as = Splitter.on((String)"-").splitToList((CharSequence)filePath)))) {
                            String orderNo = (String)as.get(as.size() - 1);
                            orderNo = orderNo.replace(".pdf", "");
                            resolveTask.setOrderNo(orderNo);
                        }
                        this.taskProducer.addTask(resolveTask);
                    }
                }
                XxlJobLogger.log((String)"\u4e0a\u4f20\u91c7\u96c6\u6587\u4ef6\u5230OSS\u5b8c\u6bd5", (Object[])new Object[0]);
            } else {
                XxlJobLogger.log((String)"\u672a\u83b7\u53d6\u5230\u9501", (Object[])new Object[0]);
                ExceptionDdNoticer.loggerError(log, "\u91c7\u96c6\u4efb\u52a1\u672a\u83b7\u53d6\u5230\u9501 \u8d26\u53f7: {}, \u5355\u636e\u7c7b\u578b: {}", account.getAccountName(), dcsJobHandler.billType());
            }
        }
        catch (Exception e) {
            log.error("\u91c7\u96c6\u6216\u89e3\u6790\u5f02\u5e38 {} {} {}", new Object[]{paramStr, dcsJobHandler.billType(), e.getMessage(), e});
            XxlJobLogger.log((String)("\u91c7\u96c6\u6216\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage()), (Object[])new Object[0]);
            if (account.isBatchRenameEnable()) {
                FileUtil.deleteFile(account);
            }
            ExceptionDdNoticer.loggerError(log, "\u91c7\u96c6\u6216\u89e3\u6790\u5f02\u5e38 \u8d26\u53f7: {}, \u5355\u636e\u7c7b\u578b: {}, {}", account.getAccountName(), dcsJobHandler.billType(), e.getMessage());
        }
        finally {
            if (lock) {
                this.redissonLock.release(key);
                XxlJobLogger.log((String)"\u9501\u5df2\u91ca\u653e", (Object[])new Object[0]);
            }
        }
        return SUCCESS;
    }

    private DcsJobHandler getDcsJobHandler() {
        DcsJobHandler dcsJobHandler = ((Object)((Object)this)).getClass().getAnnotation(DcsJobHandler.class);
        if (dcsJobHandler == null) {
            throw new RuntimeException("\u672a\u627e\u5230DcsJobHandler\u6ce8\u89e3");
        }
        return dcsJobHandler;
    }

    protected abstract AbstractLoginSys getLoginSys();

    protected abstract List<String> doCollect(WebClient var1, AccountTemplateDO var2, Map<String, String> var3) throws Exception;

    protected String getCharset() {
        return "utf-8";
    }
}

