/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.alibaba.fastjson.JSON;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.util.Cookie;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.tomcat.util.codec.binary.Base64;

public class LoginTokenUtils {
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";
    private static byte[] val = new byte[]{63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 63, 63, 63, 63, 63, 63, 63, 10, 11, 12, 13, 14, 15, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 10, 11, 12, 13, 14, 15, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};

    public static String getLoginToken(WebClient webClient, String sign, String appId, String random) {
        String result = null;
        Cookie cookie = webClient.getCookieManager().getCookie("sessionCode");
        if (null != cookie) {
            String sessionCode = webClient.getCookieManager().getCookie("sessionCode").getValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sign", sign);
            map.put("appId", appId);
            map.put("random", random);
            map.put("sessionCode", sessionCode);
            String json = JSON.toJSONString(map);
            byte[] bytes = Base64.encodeBase64((byte[])LoginTokenUtils.unescape(LoginTokenUtils.encodeURIComponent(json)).getBytes());
            return new String(bytes);
        }
        return result;
    }

    public static String getLoginToken(String sign, String appId, String sessionCode, String random) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sign", sign);
        map.put("appId", appId);
        map.put("random", random);
        map.put("sessionCode", sessionCode);
        String json = JSON.toJSONString(map);
        byte[] bytes = Base64.encodeBase64((byte[])LoginTokenUtils.unescape(LoginTokenUtils.encodeURIComponent(json)).getBytes());
        return new String(bytes);
    }

    public static String encodeURIComponent(String input) {
        if (null == input || "".equals(input.trim())) {
            return input;
        }
        int l = input.length();
        StringBuilder o = new StringBuilder(l * 3);
        try {
            for (int i = 0; i < l; ++i) {
                String e = input.substring(i, i + 1);
                if (ALLOWED_CHARS.indexOf(e) == -1) {
                    byte[] b = e.getBytes("utf-8");
                    o.append(LoginTokenUtils.getHex(b));
                    continue;
                }
                o.append(e);
            }
            return o.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return input;
        }
    }

    private static String getHex(byte[] buf) {
        StringBuilder o = new StringBuilder(buf.length * 3);
        for (int i = 0; i < buf.length; ++i) {
            int n = buf[i] & 0xFF;
            o.append("%");
            if (n < 16) {
                o.append("0");
            }
            o.append(Long.toString(n, 16).toUpperCase());
        }
        return o.toString();
    }

    public static String unescape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
                continue;
            }
            if (ch == '*' || ch == '+' || ch == '-' || ch == '/' || ch == '_' || ch == '.' || ch == '@') {
                sbuf.append(ch);
                continue;
            }
            if (ch == '%') {
                int cint = 0;
                if ('u' != s.charAt(i + 1)) {
                    cint = cint << 4 | val[s.charAt(i + 1)];
                    cint = cint << 4 | val[s.charAt(i + 2)];
                    i += 2;
                } else {
                    cint = cint << 4 | val[s.charAt(i + 2)];
                    cint = cint << 4 | val[s.charAt(i + 3)];
                    cint = cint << 4 | val[s.charAt(i + 4)];
                    cint = cint << 4 | val[s.charAt(i + 5)];
                    i += 5;
                }
                sbuf.append((char)cint);
                continue;
            }
            sbuf.append(ch);
        }
        return sbuf.toString();
    }
}

