/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RuntimeUtil;
import com.xforceplus.core.resolve.executor.MonitorExecutorService;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRuntimeLib
extends RuntimeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProcessRuntimeLib.class.getName());
    private static final ExecutorService PROCESS_POOL = MonitorExecutorService.newFixedThreadPool(15, "node-pool");

    public static String getProcessResult(String cmd, int retriesNum) {
        Optional<String> optional = IntStream.rangeClosed(0, retriesNum).mapToObj(index -> {
            try {
                String data = ProcessRuntimeLib.getProcessResult(cmd);
                LOGGER.info("runtime exec index:{},cmd:{},data:{}", new Object[]{index, cmd, data});
                return data;
            }
            catch (Exception ex) {
                String stacktrace = ExceptionUtil.stacktraceToString((Throwable)ex);
                LOGGER.error("runtime error index:{},cmd:{}, msg:{}", new Object[]{index, cmd, stacktrace});
                return "";
            }
        }).filter(CharSequenceUtil::isNotEmpty).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return "";
    }

    private static String getProcessResult(String cmd) throws Exception {
        Future<String> stringFuture = PROCESS_POOL.submit(() -> {
            Process process = RuntimeUtil.exec((String[])new String[]{cmd});
            try {
                String string;
                Throwable throwable;
                InputStream input;
                block18: {
                    block19: {
                        input = process.getInputStream();
                        throwable = null;
                        InputStreamReader streamReader = new InputStreamReader(input, CharsetUtil.CHARSET_UTF_8);
                        BufferedReader bufReader = new BufferedReader(streamReader);
                        StringBuffer stringBuffer = new StringBuffer();
                        String line = null;
                        while ((line = bufReader.readLine()) != null) {
                            stringBuffer.append(line);
                        }
                        IoUtil.close((Closeable)bufReader);
                        IoUtil.close((Closeable)streamReader);
                        string = stringBuffer.toString();
                        if (input == null) break block18;
                        if (throwable == null) break block19;
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block18;
                    }
                    input.close();
                }
                return string;
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (input != null) {
                                if (throwable != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    input.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception ex) {
                        String stackTrace = ExceptionUtil.stacktraceToString((Throwable)ex);
                        LOGGER.error("getProcessResult exception:{}", (Object)stackTrace);
                    }
                }
            }
            finally {
                ProcessRuntimeLib.destroy((Process)process);
            }
            return "";
        });
        String nodeContent = stringFuture.get(60L, TimeUnit.SECONDS);
        return nodeContent;
    }
}

