/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve;

import com.xforceplus.bean.JobBillTypeBean;
import com.xforceplus.core.annotation.DcsJobHandler;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.service.handler.DcsHandlerReporter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class TaskQueueManager {
    private final Map<JobBillTypeBean, BlockingDeque<ResolveTask>> queues = new HashMap<JobBillTypeBean, BlockingDeque<ResolveTask>>(8);
    @Resource
    private DcsHandlerReporter reporter;

    @PostConstruct
    public void init() {
        for (DcsJobHandler handler : this.reporter.getHandlerList()) {
            JobBillTypeBean bean = new JobBillTypeBean(handler.billType(), handler.version());
            this.queues.put(bean, new LinkedBlockingDeque(10000));
        }
    }

    public void addTask(ResolveTask task) throws InterruptedException {
        this.queues.get(task.getJobBillType()).put(task);
    }

    public Map<JobBillTypeBean, BlockingDeque<ResolveTask>> getQueueMap() {
        return this.queues;
    }

    public Collection<BlockingDeque<ResolveTask>> getQueues() {
        return this.queues.values();
    }
}

