/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve.json;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.xforceplus.core.resolve.AbstractFileTypeImportBean;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.utils.JsonLib;
import com.xforceplus.utils.StringLib;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class JsonImportBean
extends AbstractFileTypeImportBean {
    @Override
    public void handle1(InputStream inputStream, ResolveTask dataSource) {
        try {
            String inputStr = null;
            String charset = dataSource.getCharset();
            if (StringLib.isEmpty((CharSequence)charset)) {
                byte[] in = IOUtils.toByteArray((InputStream)inputStream);
                inputStr = StringLib.toEncodeStringWithAutoCharset(in);
            } else {
                inputStr = IOUtils.toString((InputStream)inputStream, (String)charset);
            }
            JsonNode node = JsonLib.parseJSON(inputStr);
            if (node instanceof ArrayNode) {
                this.addData("data1", JsonLib.parseArray(node, JSONObject.class));
            } else {
                this.addData("data1", JsonLib.parseMap(node));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

