/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareFileClientBuilder;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.config.AzurePepsicoProperties;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.FileUtil;
import com.xforceplus.utils.OsInfo;
import com.xforceplus.utils.zipfile.CreateFilesZip;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class FTPUtil {
    private static final Logger logger = LoggerFactory.getLogger(FTPUtil.class);
    private static FTPClient ftpClient;
    private static Integer errorTimes;

    public static void create(String server, int port, String user, String password) throws IOException {
        boolean isLogin;
        ftpClient = new FTPClient();
        ftpClient.connect(server, port);
        int reply = ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftpClient.disconnect();
            XxlJobLogger.log((String)"Exception in connecting to FTP Server", (Object[])new Object[0]);
        }
        if (isLogin = ftpClient.login(user, password)) {
            XxlJobLogger.log((String)"FTP\u8fde\u63a5\u6210\u529f\uff01", (Object[])new Object[0]);
        }
    }

    public static void close() throws IOException {
        ftpClient.disconnect();
    }

    public static void uploadFile(File localFile, String originPath, AccountTemplateDO account) {
        BufferedInputStream input = null;
        String fileName = localFile.getName();
        try {
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(originPath);
            ftpClient.setFileType(2);
            ftpClient.setBufferSize(0x100000);
            byte[] fileBytes = FTPUtil.getFileByteArray(localFile);
            assert (fileBytes != null);
            input = new BufferedInputStream(new ByteArrayInputStream(fileBytes));
            if (!fileName.endsWith(".pdf") && !fileName.endsWith(".xml")) {
                XxlJobLogger.log((String)"{} \u6587\u4ef6\u540e\u7f00\u4e0d\u5408\u6cd5,\u8df3\u8fc7\u4e0a\u4f20\uff01", (Object[])new Object[]{fileName});
                return;
            }
            if (ftpClient.storeFile(fileName, (InputStream)input)) {
                XxlJobLogger.log((String)(localFile.getName() + "\u4e0a\u4f20\u6210\u529f"), (Object[])new Object[0]);
            } else {
                XxlJobLogger.log((String)(localFile.getName() + "----\u4e0a\u4f20\u5931\u8d25--------------"), (Object[])new Object[0]);
                FTPUtil.create(account.getSiteUrl(), Integer.parseInt(account.getPort()), account.getAccountName(), account.getAccountPassword());
                ftpClient.enterLocalPassiveMode();
                ftpClient.changeWorkingDirectory(originPath);
                ftpClient.setFileType(2);
                boolean isFlag = ftpClient.storeFile(fileName, (InputStream)input);
                if (isFlag) {
                    XxlJobLogger.log((String)(localFile.getName() + "-------\u4e0a\u4f20\u5931\u8d25\u4e4b\u540e\u518d\u6b21\u4e0a\u4f20\u6210\u529f---------"), (Object[])new Object[0]);
                } else {
                    XxlJobLogger.log((String)(localFile.getName() + "------\u4e0a\u4f20\u5931\u8d25\u4e4b\u540e\u518d\u6b21\u4e0a\u4f20\u5931\u8d25----------"), (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)(fileName + "\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff01{}"), (Object[])new Object[]{FTPUtil.getPrintExceptions(e)});
            for (int i = 1; i < 11; ++i) {
                try {
                    XxlJobLogger.log((String)"-------\u91cd\u65b0\u767b\u9646-------", (Object[])new Object[0]);
                    FTPUtil.create(account.getSiteUrl(), Integer.parseInt(account.getPort()), account.getAccountName(), account.getAccountPassword());
                    ftpClient.enterLocalPassiveMode();
                    ftpClient.changeWorkingDirectory(originPath);
                    ftpClient.setFileType(2);
                    ftpClient.setBufferSize(0x100000);
                    byte[] fileBytes = FTPUtil.getFileByteArray(localFile);
                    assert (fileBytes != null);
                    BufferedInputStream input1 = new BufferedInputStream(new ByteArrayInputStream(fileBytes));
                    boolean isFlag = ftpClient.storeFile(fileName, (InputStream)input1);
                    if (isFlag) {
                        XxlJobLogger.log((String)(localFile.getName() + "-----\u5f02\u5e38\u4e4b\u540e\u518d\u6b21\u4e0a\u4f20\u6210\u529f------"), (Object[])new Object[0]);
                    } else {
                        XxlJobLogger.log((String)(localFile.getName() + "------\u5f02\u5e38\u4e4b\u540e\u518d\u6b21\u4e0a\u4f20\u5931\u8d25----------"), (Object[])new Object[0]);
                    }
                    input1.close();
                    break;
                }
                catch (IOException e2) {
                    XxlJobLogger.log((String)("\u5f02\u5e38\u4e4b\u540e\u518d\u6b21\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff01******\u7b2c " + i + " \u6b21\u5931\u8d25****** : {}"), (Object[])new Object[]{FTPUtil.getPrintExceptions(e)});
                    continue;
                }
            }
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                XxlJobLogger.log((String)"\u5173\u95edinput\u5f02\u5e38: {}", (Object[])new Object[]{FTPUtil.getPrintExceptions(e)});
            }
        }
    }

    public static boolean uploadFileVersionLevel(File localFile, String originPath, List<Object> connects, AccountTemplateDO account) {
        block11: {
            if (connects != null) {
                ChannelSftp channelSftp = (ChannelSftp)connects.get(0);
                try {
                    String name = localFile.getName();
                    if (!name.startsWith(".")) {
                        boolean bool = FTPUtil.upLoadFile(originPath, name, FTPUtil.getFileByteArray(localFile), channelSftp, account);
                        if (bool) {
                            boolean result = localFile.delete();
                            XxlJobLogger.log((String)("\u5220\u9664\u7f13\u5b58\u7ed3\u679c file:" + localFile.getAbsolutePath() + " result:" + result), (Object[])new Object[0]);
                            return true;
                        }
                        break block11;
                    }
                    XxlJobLogger.log((String)("\u4e0a\u4f20->  " + originPath + "/" + name + "---\u6587\u4ef6\u5f00\u5934\u51fa\u73b0\u5e26\u6709.\u7684\uff0c\u8fd8\u6ca1\u6709\u751f\u6210\u5b8c\u6bd5\u7684\u6587\u4ef6,\u7a0d\u540e\u4e0a\u4f20"), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38, \u6b63\u5728\u5c1d\u8bd5\u91cd\u8bd5: {}", (Object[])new Object[]{FTPUtil.getPrintExceptions(e)});
                    XxlJobLogger.log((Throwable)e);
                    FTPUtil.sleep(1);
                    try {
                        String name = localFile.getName();
                        if (!name.startsWith(".")) {
                            boolean bool = FTPUtil.upLoadFile(originPath, name, FTPUtil.getFileByteArray(localFile), channelSftp, account);
                            if (bool) {
                                boolean result = localFile.delete();
                                XxlJobLogger.log((String)("\u5220\u9664\u7f13\u5b58\u7ed3\u679c file:" + localFile.getAbsolutePath() + " result:" + result), (Object[])new Object[0]);
                                return true;
                            }
                        } else {
                            XxlJobLogger.log((String)("\u4e0a\u4f20->  " + originPath + "/" + name + "---\u6587\u4ef6\u5f00\u5934\u51fa\u73b0\u5e26\u6709.\u7684\uff0c\u8fd8\u6ca1\u6709\u751f\u6210\u5b8c\u6bd5\u7684\u6587\u4ef6,\u7a0d\u540e\u4e0a\u4f20"), (Object[])new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        XxlJobLogger.log((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38, \u6b63\u5728\u5c1d\u8bd5\u91cd\u8bd5: {}", (Object[])new Object[]{FTPUtil.getPrintExceptions(e)});
                        XxlJobLogger.log((Throwable)e);
                    }
                }
            } else {
                XxlJobLogger.log((String)"\u672a\u83b7\u53d6\u94fe\u63a5", (Object[])new Object[0]);
            }
        }
        return false;
    }

    public static String getPrintExceptions(Exception e) {
        e.printStackTrace();
        StackTraceElement s = e.getStackTrace()[0];
        return "ExceptionMsgAsFollows:\u2193\r\nClassName" + s.getClassName() + "\r\nMethodName:" + s.getMethodName() + "\r\nLineNumber:" + s.getLineNumber() + "\r\nExceptionReason:" + e.getMessage();
    }

    public static byte[] getFileByteArray(File file) {
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            XxlJobLogger.log((String)"file too big...", (Object[])new Object[0]);
            return null;
        }
        byte[] buffer = null;
        try (FileInputStream fi = new FileInputStream(file);){
            int offset;
            int numRead;
            buffer = new byte[(int)fileSize];
            for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
            }
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static List<Object> getMustConnects(String a_userName, String a_host, Integer a_port, String a_passWord) throws Exception {
        List<Object> connect = FTPUtil.getConnect(a_userName, a_host, a_port, a_passWord);
        if (connect != null && connect.size() == 3) {
            XxlJobLogger.log((String)"\u8fde\u63a5\u6210\u529f", (Object[])new Object[0]);
            return connect;
        }
        for (int i = 1; i <= 3; ++i) {
            XxlJobLogger.log((String)(a_host + " - \u8fde\u63a5\u5931\u8d25,\u6b63\u5728\u5c1d\u8bd5\u8fde\u63a5\u7b2c" + i + "\u6b21..."), (Object[])new Object[0]);
            Thread.sleep(BaseUtils.randomLong(3, 1));
            XxlJobLogger.log((String)"...", (Object[])new Object[0]);
            Thread.sleep(BaseUtils.randomLong(3, 1));
            connect = FTPUtil.getConnect(a_userName, a_host, a_port, a_passWord);
            if (connect != null && connect.size() == 3) break;
        }
        if (connect != null && connect.size() == 3) {
            XxlJobLogger.log((String)"\u8fde\u63a5\u6210\u529f", (Object[])new Object[0]);
            return connect;
        }
        XxlJobLogger.log((String)"\u8fde\u63a5\u5931\u8d25", (Object[])new Object[0]);
        return null;
    }

    public static Boolean cachePepsico(String a_host, String a_port, String a_userName, String a_passWord, String ftpTargetPath, String ftpBackPath, String cacheTargetPath) throws Exception {
        List<Object> connects = FTPUtil.getMustConnects(a_userName, a_host, Integer.parseInt(a_port), a_passWord);
        if (connects == null) {
            XxlJobLogger.log((String)("\u8ba4\u8bc1 " + a_host + " \u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad"), (Object[])new Object[0]);
            return false;
        }
        XxlJobLogger.log((String)"\u6b65\u9aa41.0 , \u6b63\u5728\u786e\u8ba4\u76ee\u6807\u76ee\u5f55\u548c\u5907\u4efd\u76ee\u5f55\u662f\u5426\u5b58\u5728...", (Object[])new Object[0]);
        ChannelSftp sftpChannel = (ChannelSftp)connects.get(0);
        Channel channel = (Channel)connects.get(1);
        Session session = (Session)connects.get(2);
        try {
            if (!FTPUtil.createDir(ftpBackPath, sftpChannel)) {
                return false;
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u5f53\u524d\u8def\u5f84\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        ArrayList<String> fullFileNames = new ArrayList<String>();
        XxlJobLogger.log((String)"\u64cd\u4f5c2.0, \u83b7\u53d6\u6587\u4ef6\u540d...", (Object[])new Object[0]);
        try {
            List<String> ls = FTPUtil.cacheMoveFileGetLs(connects, ftpTargetPath);
            if (ls == null) {
                XxlJobLogger.log((String)"\u64cd\u4f5c2.0 - ls \u4e3a\u7a7a, \u6b64\u6b21\u4efb\u52a1\u7ec8\u6b62", (Object[])new Object[0]);
                return false;
            }
            fullFileNames.addAll(ls);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u64cd\u4f5c2.0 - \u9519\u8bef,\u6b64\u6b21\u4efb\u52a1\u7ec8\u6b62(500-\u7a0b\u5e8f\u5185\u90e8\u51fa\u9519)", (Object[])new Object[0]);
            return false;
        }
        XxlJobLogger.log((String)"\u64cd\u4f5c3.0, \u5c06\u6587\u4ef6\u7f13\u5b58\u81f3\u672c\u5730...", (Object[])new Object[0]);
        for (String fileName : fullFileNames) {
            try {
                FTPUtil.download(connects, ftpTargetPath, fileName, cacheTargetPath);
                XxlJobLogger.log((String)(ftpTargetPath + "/" + fileName + " --\u7f13\u5b58\u672c\u5730\u6210\u529f"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                XxlJobLogger.log((String)("\u64cd\u4f5c3.0 - \u9519\u8bef,\u6b64\u6b21\u4efb\u52a1\u7ec8\u6b62(500-\u7a0b\u5e8f\u5185\u90e8\u51fa\u9519)" + fileName), (Object[])new Object[0]);
                return false;
            }
        }
        XxlJobLogger.log((String)"\u6b65\u9aa44.0, \u5c06\u6587\u4ef6\u8fdb\u884c\u5907\u4efd...", (Object[])new Object[0]);
        for (String fileName : fullFileNames) {
            try {
                boolean rename = FTPUtil.rename(connects, ftpTargetPath + "/" + fileName, ftpBackPath + "/" + fileName);
                if (rename) {
                    XxlJobLogger.log((String)(ftpTargetPath + "/" + fileName + " --->\u5907\u4efd\u81f3---> " + ftpBackPath + "/" + fileName + " --> \u6210\u529f"), (Object[])new Object[0]);
                    continue;
                }
                XxlJobLogger.log((String)(ftpTargetPath + "/" + fileName + " ---> \u5907\u4efd\u5931\u8d25"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u64cd\u4f5c4.0 - \u9519\u8bef,\u6b64\u6b21\u4efb\u52a1\u7ec8\u6b62(500-\u7a0b\u5e8f\u5185\u90e8\u51fa\u9519)", (Object[])new Object[0]);
                return false;
            }
        }
        if (connects.size() == 3) {
            FTPUtil.closeChannel((Channel)sftpChannel);
            FTPUtil.closeChannel(channel);
            FTPUtil.closeSession(session);
        }
        return true;
    }

    public static void uploadPepsico(File file, String originPath, AccountTemplateDO account) {
        Object[] fs = file.listFiles();
        if (!ObjectUtils.isEmpty((Object[])fs)) {
            List<Object> connects;
            ArrayList<String> sortFileNames = new ArrayList<String>();
            HashMap oom = new HashMap();
            for (Object f : fs) {
                List<Object> files;
                String name = ((File)f).getName().replace(".xml", "");
                String[] s = name.split("_");
                String s1 = s[s.length - 1];
                if (!sortFileNames.contains(s1)) {
                    sortFileNames.add(s1);
                }
                if (oom.get(s1) != null) {
                    files = (List)oom.get(s1);
                    files.add(f);
                    oom.put(s1, files);
                    continue;
                }
                files = new ArrayList();
                files.add(f);
                oom.put(s1, files);
            }
            Collections.sort(sortFileNames);
            if (sortFileNames.isEmpty()) {
                XxlJobLogger.log((String)"\u672a\u627e\u5230\u6587\u4ef6,\u6b64\u6b21\u4f20\u8f93\u7ec8\u6b62", (Object[])new Object[0]);
                return;
            }
            try {
                String b_host = account.getSiteUrl();
                int b_port = Integer.parseInt(account.getPort());
                String b_userName = account.getAccountName();
                String b_password = account.getAccountPassword();
                connects = FTPUtil.getMustConnects(b_userName, b_host, b_port, b_password);
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u4f20\u8f93\u6587\u4ef6\u94fe\u63a5\u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad", (Object[])new Object[0]);
                return;
            }
            for (String sortFileName : sortFileNames) {
                List files = (List)oom.get(sortFileName);
                files.forEach(o -> {
                    if (o.isFile()) {
                        FTPUtil.uploadFileVersionLevel(o, originPath, connects, account);
                    }
                });
            }
            try {
                if (connects != null) {
                    ChannelSftp channelSftp = (ChannelSftp)connects.get(0);
                    Channel channel = (Channel)connects.get(1);
                    Session sshSession = (Session)connects.get(2);
                    channelSftp.quit();
                    channelSftp.disconnect();
                    channel.disconnect();
                    sshSession.disconnect();
                    XxlJobLogger.log((String)"close pipeline", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"close pipeline exception", (Object[])new Object[0]);
            }
        }
    }

    public static String getDatePath() {
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
        return yyyyMMdd.format(new Date());
    }

    public static void upload(File file, String originPath, AccountTemplateDO account) {
        File[] fs = file.listFiles();
        assert (fs != null);
        for (File f : fs) {
            if (f.isDirectory()) {
                FTPUtil.upload(f, originPath, account);
            }
            if (!f.isFile()) continue;
            FTPUtil.uploadFile(f, originPath, account);
        }
    }

    public static boolean upLoadFile(String rpath, String rFileName, byte[] fileData, ChannelSftp sftpChannel, AccountTemplateDO account) {
        boolean b = FTPUtil.retryCd(rpath, sftpChannel);
        if (!b) {
            return b;
        }
        Integer isBatchRename = account.getIsBatchRename();
        if (isBatchRename != null && isBatchRename == 1) {
            String tmpFileName = "." + rFileName;
            b = FTPUtil.retryWrite(tmpFileName, fileData, sftpChannel);
            if (!b) {
                return b;
            }
            b = FTPUtil.retryRename(tmpFileName, rFileName, sftpChannel);
            if (!b) {
                return b;
            }
        } else {
            b = FTPUtil.retryWrite(rFileName, fileData, sftpChannel);
            if (!b) {
                return b;
            }
        }
        XxlJobLogger.log((String)("\u4e0a\u4f20->  " + rpath + "/" + rFileName + "---\u6210\u529f"), (Object[])new Object[0]);
        return true;
    }

    private static void sleep(int i) {
        try {
            XxlJobLogger.log((String)("\u6682\u505c" + i + "\u79d2"), (Object[])new Object[0]);
            Thread.sleep(i * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean retryMkdir(String path, ChannelSftp sftp) {
        for (int i = 0; i < 2; ++i) {
            try {
                sftp.mkdir(path);
                return true;
            }
            catch (SftpException ex) {
                XxlJobLogger.log((String)("mkdir\u76ee\u5f55\u62a5\u9519" + i + ":" + path), (Object[])new Object[0]);
                XxlJobLogger.log((Throwable)ex);
                FTPUtil.sleep(1);
                continue;
            }
        }
        return false;
    }

    public static boolean retryCd(String path, ChannelSftp sftp) {
        for (int i = 0; i < 2; ++i) {
            try {
                sftp.cd(path);
                return true;
            }
            catch (SftpException ex) {
                XxlJobLogger.log((String)("cd\u76ee\u5f55\u62a5\u9519" + i + ":" + path), (Object[])new Object[0]);
                XxlJobLogger.log((Throwable)ex);
                FTPUtil.sleep(1);
                continue;
            }
        }
        return false;
    }

    public static boolean retryRename(String tmpFileName, String fileName, ChannelSftp sftp) {
        for (int i = 0; i < 2; ++i) {
            try {
                sftp.rename(tmpFileName, fileName);
                return true;
            }
            catch (SftpException ex) {
                XxlJobLogger.log((String)("\u91cd\u547d\u540d\u5931\u8d25" + i + ":" + tmpFileName + ":" + fileName), (Object[])new Object[0]);
                XxlJobLogger.log((Throwable)ex);
                FTPUtil.sleep(1);
                continue;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean retryWrite(String fileName, byte[] fileData, ChannelSftp sftp) {
        int i = 0;
        while (i < 2) {
            try (OutputStream os = sftp.put(fileName);){
                IOUtils.write((byte[])fileData, (OutputStream)os);
                boolean bl = true;
                return bl;
            }
            catch (SftpException | IOException ex) {
                XxlJobLogger.log((String)("\u5199\u5165\u6587\u4ef6\u5f02\u5e38" + i + ":" + fileName), (Object[])new Object[0]);
                XxlJobLogger.log((Throwable)ex);
                FTPUtil.sleep(1);
                ++i;
            }
        }
        return false;
    }

    public static boolean rename(List<Object> allConnect, String oFile, String nFile) {
        ChannelSftp sftpChannel = (ChannelSftp)allConnect.get(0);
        try {
            sftpChannel.rename(oFile, nFile);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List<String> cacheMoveFileGetLs(List<Object> allConnect, String path) {
        List<String> fs = null;
        ChannelSftp channelSftp = (ChannelSftp)allConnect.get(0);
        try {
            Vector fileList = channelSftp.ls(path);
            fs = FTPUtil.parseList(fileList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(List<Object> allConnect, String directory, String downloadFile, String saveDirectory) throws Exception {
        ChannelSftp sftpChannel = (ChannelSftp)allConnect.get(0);
        try (FileOutputStream fileOutputStream = null;){
            String saveFile = saveDirectory + "/" + downloadFile;
            sftpChannel.cd(directory);
            File file = new File(saveFile);
            fileOutputStream = new FileOutputStream(file);
            sftpChannel.get(downloadFile, (OutputStream)fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download2(List<Object> allConnect, String directory, String saveDirectory) throws Exception {
        ChannelSftp sftpChannel = (ChannelSftp)allConnect.get(0);
        FileOutputStream fileOutputStream = null;
        try {
            sftpChannel.cd(directory);
            FTPUtil.lsFolderCopy(directory, saveDirectory, sftpChannel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            assert (false);
            fileOutputStream.close();
        }
    }

    private static void lsFolderCopy(String sourcePath, String destPath, ChannelSftp sftpChannel) throws SftpException {
        Vector list = sftpChannel.ls(sourcePath);
        for (ChannelSftp.LsEntry oListItem : list) {
            if (!oListItem.getAttrs().isDir()) {
                if (new File(destPath + "/" + oListItem.getFilename()).exists() && oListItem.getAttrs().getMTime() <= Long.valueOf(new File(destPath + "/" + oListItem.getFilename()).lastModified() / 1000L).intValue()) continue;
                new File(destPath + "/" + oListItem.getFilename());
                sftpChannel.get(sourcePath + "/" + oListItem.getFilename(), destPath + "/" + oListItem.getFilename());
                continue;
            }
            if (".".equals(oListItem.getFilename()) || "..".equals(oListItem.getFilename())) continue;
            new File(destPath + "/" + oListItem.getFilename()).mkdirs();
            FTPUtil.lsFolderCopy(sourcePath + "/" + oListItem.getFilename(), destPath + "/" + oListItem.getFilename(), sftpChannel);
        }
    }

    public static List<Object> getConnect(String username, String host, Integer port, String password) {
        LinkedList<Object> list = new LinkedList<Object>();
        try {
            JSch jsch = new JSch();
            jsch.getSession(username, host, port.intValue());
            Session sshSession = jsch.getSession(username, host, port.intValue());
            sshSession.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
            sshSession.setPassword(password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshConfig.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
            sshSession.setConfig(sshConfig);
            sshSession.connect();
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            ChannelSftp sftp = (ChannelSftp)channel;
            list.add(sftp);
            list.add(channel);
            list.add(sshSession);
            return list;
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"SFTP\u8fde\u63a5\u5f02\u5e38", (Object[])new Object[0]);
            XxlJobLogger.log((Throwable)e);
            return list;
        }
    }

    private static void closeChannel(Channel channel) {
        if (channel != null && channel.isConnected()) {
            channel.disconnect();
        }
    }

    private static void closeSession(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }

    public static List<String> parseList(Vector fileList) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = fileList.iterator();
        while (it.hasNext()) {
            String fileName = ((ChannelSftp.LsEntry)it.next()).getFilename();
            if (".".equals(fileName) || "..".equals(fileName)) continue;
            list.add(fileName);
        }
        return list;
    }

    public static boolean createDir(String createpath, ChannelSftp sftp) {
        boolean b;
        if (FTPUtil.isDirExist(createpath, sftp) && !(b = FTPUtil.retryCd(createpath, sftp))) {
            return b;
        }
        String[] pathArry = createpath.split("/");
        StringBuffer filePath = new StringBuffer("/");
        for (String path : pathArry) {
            boolean b2;
            if ("".equals(path)) continue;
            filePath.append(path + "/");
            if (FTPUtil.isDirExist(filePath.toString(), sftp)) {
                b2 = FTPUtil.retryCd(filePath.toString(), sftp);
                if (b2) continue;
                return b2;
            }
            b2 = FTPUtil.retryMkdir(filePath.toString(), sftp);
            if (!b2) {
                return b2;
            }
            XxlJobLogger.log((String)("\u5efa\u7acb\u76ee\u5f55 -> " + filePath), (Object[])new Object[0]);
            b2 = FTPUtil.retryCd(filePath.toString(), sftp);
            if (!b2) {
                return b2;
            }
            XxlJobLogger.log((String)("\u8fdb\u5165\u5e76\u8bbe\u7f6e\u4e3a\u5f53\u524d\u76ee\u5f55 -> " + filePath), (Object[])new Object[0]);
        }
        boolean b3 = FTPUtil.retryCd(createpath, sftp);
        if (!b3) {
            return b3;
        }
        return true;
    }

    public static boolean isDirExist(String directory, ChannelSftp sftp) {
        try {
            SftpATTRS sftpATTRS = sftp.lstat(directory);
            return sftpATTRS.isDir();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Boolean TestPepsicoConnect(String host, String port, String userName, String password) {
        List<Object> connects = FTPUtil.getConnect(userName, host, Integer.parseInt(port), password);
        if (connects.size() == 3) {
            ChannelSftp channelSftp = (ChannelSftp)connects.get(0);
            Channel channel = (Channel)connects.get(1);
            Session sshSession = (Session)connects.get(2);
            FTPUtil.closeChannel((Channel)channelSftp);
            FTPUtil.closeChannel(channel);
            FTPUtil.closeSession(sshSession);
            XxlJobLogger.log((String)("\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f --> " + host + " --> \u5df2\u6b63\u5e38\u5173\u95ed\u6d4b\u8bd5\u8fde\u63a5"), (Object[])new Object[0]);
            return true;
        }
        XxlJobLogger.log((String)("\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25 --> " + host), (Object[])new Object[0]);
        return false;
    }

    public static Boolean TestPepsicoConnect1(String host, String port, String userName, String password) throws IOException {
        FTPClient ftpClient = FTPUtil.pepsicoCreate(host, Integer.parseInt(port), userName, password);
        if (ftpClient != null) {
            ftpClient.disconnect();
            XxlJobLogger.log((String)("\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f --> " + host + " --> \u5df2\u6b63\u5e38\u5173\u95ed\u6d4b\u8bd5\u8fde\u63a5"), (Object[])new Object[0]);
            return true;
        }
        XxlJobLogger.log((String)("\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25 --> " + host), (Object[])new Object[0]);
        return false;
    }

    public static FTPClient pepsicoCreate(String server, int port, String user, String password) throws IOException {
        int reply;
        FTPClient ftp = new FTPClient();
        ftp.connect(server, port);
        boolean isLogin = ftp.login(user, password);
        if (isLogin) {
            XxlJobLogger.log((String)"FTP\u8fde\u63a5\u6210\u529f\uff01", (Object[])new Object[0]);
        }
        if (!FTPReply.isPositiveCompletion((int)(reply = ftp.getReplyCode()))) {
            ftp.disconnect();
            XxlJobLogger.log((String)"Exception in connecting to FTP Server", (Object[])new Object[0]);
            return null;
        }
        return ftp;
    }

    public static void pepsicoClose(FTPClient pepFtpClient) throws IOException {
        pepFtpClient.disconnect();
        XxlJobLogger.log((String)"\u65ad\u5f00\u8fde\u63a5\u6210\u529f", (Object[])new Object[0]);
    }

    public static void pepsicoUploadFile(File localFile, String uploadPath, AccountTemplateDO account, FTPClient pepFtpClient, int total, AtomicInteger currentSize) {
        block17: {
            String fileNameOld = localFile.getName() + ".tmp";
            try {
                byte[] fileBytes = FTPUtil.getFileByteArray(localFile);
                assert (fileBytes != null);
                BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(fileBytes));
                pepFtpClient.enterLocalPassiveMode();
                pepFtpClient.changeWorkingDirectory(uploadPath);
                pepFtpClient.setFileType(2);
                pepFtpClient.setBufferSize(0x200000);
                pepFtpClient.setDataTimeout(30000);
                boolean isFlag1 = pepFtpClient.storeFile(fileNameOld, (InputStream)input);
                if (isFlag1) {
                    try {
                        Thread thread = Thread.currentThread();
                        if (thread.isInterrupted()) {
                            XxlJobLogger.log((String)"\u5f53\u524d\u7ebf\u7a0b\u7ec8\u7ed3", (Object[])new Object[0]);
                            thread.interrupt();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    XxlJobLogger.log((String)(fileNameOld + "-------\u4e0a\u4f20\u6210\u529f ---------\u603b: " + total + ",\u5f53\u524d: " + currentSize), (Object[])new Object[0]);
                    String fileNameNew = fileNameOld.replaceFirst("\\.tmp", "");
                    boolean rename = pepFtpClient.rename(fileNameOld, fileNameNew);
                    if (rename) {
                        boolean delete = localFile.delete();
                        XxlJobLogger.log((String)(fileNameOld + "  \u66f4\u540d\u4e3a  " + fileNameNew + " \u6e05\u9664\u6587\u4ef6\u6210\u529f:" + delete), (Object[])new Object[0]);
                    } else {
                        XxlJobLogger.log((String)"\u53bb\u9664\u6587\u4ef6\u540e\u7f00\u5931\u8d25,\u6b63\u5728\u91cd\u65b0\u5c1d\u8bd5\u66f4\u540d", (Object[])new Object[0]);
                        rename = pepFtpClient.rename(fileNameOld, fileNameNew);
                        if (rename) {
                            XxlJobLogger.log((String)"\u91cd\u8bd5\u5c1d\u8bd5\u66f4\u540d\u6210\u529f", (Object[])new Object[0]);
                        } else {
                            XxlJobLogger.log((String)"\u91cd\u8bd5\u547d\u540d\u5931\u8d25,\u5f53\u524d\u6587\u4ef6\u4e22\u5931", (Object[])new Object[0]);
                        }
                    }
                    break block17;
                }
                XxlJobLogger.log((String)(localFile.getName() + "------\u4e0a\u4f20\u5931\u8d25 ----------\u603b: " + total + ",\u5f53\u524d: " + currentSize), (Object[])new Object[0]);
                FTPUtil.pepsicoClose(pepFtpClient);
                XxlJobLogger.log((String)(localFile.getName() + "-\u8be5\u6587\u4ef6\u6b63\u5728\u9012\u5f52\u91cd\u8bd5\u4e0a\u4f20,\u4ee5\u4fdd\u8bc1\u4e00\u5b9a\u4e0a\u4f20\u6210\u529f..."), (Object[])new Object[0]);
                pepFtpClient = FTPUtil.pepsicoCreate(account.getSiteUrl(), Integer.parseInt(account.getPort()), account.getAccountName(), account.getAccountPassword());
                FTPUtil.pepsicoUploadFile(localFile, uploadPath, account, pepFtpClient, total, currentSize);
            }
            catch (Exception e) {
                try {
                    XxlJobLogger.log((String)(localFile.getName() + "------##**\u4e0a\u4f20\u5f02\u5e38**##----------\u603b: " + total + ",\u5f53\u524d: " + currentSize), (Object[])new Object[0]);
                    assert (pepFtpClient != null);
                    FTPUtil.pepsicoClose(pepFtpClient);
                    XxlJobLogger.log((String)(localFile.getName() + "-\u8be5\u6587\u4ef6\u6b63\u5728\u9012\u5f52\u91cd\u8bd5\u4e0a\u4f20,\u4ee5\u4fdd\u8bc1\u4e00\u5b9a\u4e0a\u4f20\u6210\u529f..."), (Object[])new Object[0]);
                    pepFtpClient = FTPUtil.pepsicoCreate(account.getSiteUrl(), Integer.parseInt(account.getPort()), account.getAccountName(), account.getAccountPassword());
                    FTPUtil.pepsicoUploadFile(localFile, uploadPath, account, pepFtpClient, total, currentSize);
                }
                catch (Exception e1) {
                    XxlJobLogger.log((String)"\u5728catch\u4e2d\u4f9d\u65e7\u62a5\u9519,\u5f53\u524d\u6587\u4ef6\u4f20\u8f93\u4e22\u5931\u505c\u6b62,\u8bf7\u53bb\u5907\u4efd\u6587\u4ef6\u67e5\u770b", (Object[])new Object[0]);
                    try {
                        assert (pepFtpClient != null);
                        FTPUtil.pepsicoClose(pepFtpClient);
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
            }
        }
    }

    public static void sftpDirectUploadFile2Service(File cacheTargetFiles, String originPath, AccountTemplateDO account) throws Exception {
        Object[] fs = cacheTargetFiles.listFiles();
        if (!ObjectUtils.isEmpty((Object[])fs)) {
            List<Object> files;
            ArrayList<String> sortFileNames = new ArrayList<String>();
            HashMap oom = new HashMap();
            for (Object f : fs) {
                String name = ((File)f).getName().replace(".xml", "");
                String[] s = name.split("_");
                String s1 = s[s.length - 1];
                if (!sortFileNames.contains(s1)) {
                    sortFileNames.add(s1);
                }
                if (oom.get(s1) != null) {
                    files = (List)oom.get(s1);
                    files.add(f);
                    oom.put(s1, files);
                    continue;
                }
                files = new ArrayList();
                files.add(f);
                oom.put(s1, files);
            }
            Collections.sort(sortFileNames);
            long start = System.currentTimeMillis();
            FTPClient pepFtpClient = FTPUtil.pepsicoCreate(account.getSiteUrl(), Integer.parseInt(account.getPort()), account.getAccountName(), account.getAccountPassword());
            int total = fs.length;
            AtomicInteger currentSize = new AtomicInteger(0);
            for (String sortFileName : sortFileNames) {
                files = (List)oom.get(sortFileName);
                files.forEach(file -> {
                    try {
                        Thread thread = Thread.currentThread();
                        if (thread.isInterrupted()) {
                            thread.interrupt();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (file.isFile() && file.exists()) {
                        currentSize.getAndIncrement();
                        FTPUtil.pepsicoUploadFile(file, originPath, account, pepFtpClient, total, currentSize);
                    }
                });
            }
            long end = System.currentTimeMillis();
            XxlJobLogger.log((String)("\u6240\u6709\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210,\u4e0a\u4f20\u6240\u8017\u65f6: " + FTPUtil.secondToTime((end - start) / 1000L)), (Object[])new Object[0]);
            assert (pepFtpClient != null);
            FTPUtil.pepsicoClose(pepFtpClient);
        }
    }

    public static boolean uploadAzurePepsico(File cacheTargetFiles, String ftpSavePath, String originPath, AzurePepsicoProperties properties) throws Exception {
        Object[] fs = cacheTargetFiles.listFiles();
        if (!ObjectUtils.isEmpty((Object[])fs)) {
            List<Object> files;
            ArrayList<String> sortFileNames = new ArrayList<String>();
            HashMap oom = new HashMap();
            ArrayList<String> existFileList = new ArrayList<String>();
            FTPUtil.loadExistFile(originPath, existFileList, properties);
            for (Object f : fs) {
                if (existFileList.contains(((File)f).getName())) {
                    boolean flag = ((File)f).delete();
                    XxlJobLogger.log((String)(((File)f).getName() + "\u6587\u4ef6\u5df2\u4e0a\u4f20\u5230\u5fae\u8f6f\u4e91,\u6b64\u6b21\u4e0d\u8fdb\u884c\u4e0a\u4f20,\u5220\u9664\u672c\u5730\u7f13\u5b58\u6587\u4ef6:" + flag), (Object[])new Object[0]);
                    continue;
                }
                String name = ((File)f).getName().replace(".xml", "");
                String[] s = name.split("_");
                String s1 = s[s.length - 1];
                if (!sortFileNames.contains(s1)) {
                    sortFileNames.add(s1);
                }
                if (oom.get(s1) != null) {
                    files = (List)oom.get(s1);
                    files.add(f);
                    oom.put(s1, files);
                    continue;
                }
                files = new ArrayList();
                files.add(f);
                oom.put(s1, files);
            }
            if (sortFileNames.isEmpty()) {
                return false;
            }
            Collections.sort(sortFileNames);
            long start = System.currentTimeMillis();
            HashMap fileMaps = new HashMap();
            AtomicBoolean isFlag = new AtomicBoolean(false);
            AtomicInteger currentSize = new AtomicInteger(0);
            for (String sortFileName : sortFileNames) {
                files = (ArrayList)oom.get(sortFileName);
                files.forEach(file -> {
                    if (file.isFile() && file.exists()) {
                        currentSize.getAndIncrement();
                        errorTimes = 0;
                        String path = file.getAbsolutePath();
                        String fileName = file.getName();
                        String destPathName = ftpSavePath + fileName;
                        FTPUtil.uploadFileShare(path, destPathName, sortFileNames.size(), currentSize, fileName, properties);
                        if (errorTimes > 10) {
                            isFlag.set(true);
                            XxlJobLogger.log((String)(fileName + " \u6587\u4ef6\u5df2\u91cd\u8bd510\u6b21\u4e0a\u4f20,\u6b64\u6587\u4ef6\u4ee5\u4e0a\u4f20\u5931\u8d25\u544a\u7ec8"), (Object[])new Object[0]);
                        }
                        fileMaps.put(fileName, file);
                    }
                });
            }
            if (isFlag.get()) {
                return false;
            }
        }
        return true;
    }

    private static void loadExistFile(String fileSharePath, List<String> existFileList, AzurePepsicoProperties properties) {
        block2: {
            try {
                ShareDirectoryClient dirClient = new ShareFileClientBuilder().endpoint(FTPUtil.getStorageConnectionString(properties)).sasToken(properties.getSasToken()).shareName(properties.getShareName()).resourcePath(fileSharePath).buildDirectoryClient();
                dirClient.listFilesAndDirectories().forEach(o -> existFileList.add(o.getName()));
            }
            catch (Exception e) {
                if (!e.getLocalizedMessage().contains("ResourceNotFound")) break block2;
                XxlJobLogger.log((String)"\u7b2c\u4e00\u6b21\u4e0a\u4f20, \u6587\u4ef6\u76ee\u5f55\u8fd8\u672a\u521b\u5efa", (Object[])new Object[0]);
            }
        }
    }

    private static void uploadIsSuccess(Map<String, File> fileMaps, String fileSharePath, Long start, Long end, AzurePepsicoProperties properties) {
        XxlJobLogger.log((String)"\u6b65\u9aa45.0, \u5f00\u59cb\u6821\u9a8c\u662f\u5426\u4e0a\u4f20\u6210\u529f...", (Object[])new Object[0]);
        ShareDirectoryClient dirClient = new ShareFileClientBuilder().endpoint(FTPUtil.getStorageConnectionString(properties)).sasToken(properties.getSasToken()).shareName(properties.getShareName()).resourcePath(fileSharePath).buildDirectoryClient();
        AtomicInteger successNum = new AtomicInteger(0);
        ArrayList<String> allList = new ArrayList<String>(fileMaps.keySet());
        ArrayList successList = new ArrayList();
        dirClient.listFilesAndDirectories().forEach(o -> {
            String fileName = o.getName();
            Long fileSize = o.getFileSize();
            if (fileMaps.containsKey(o.getName())) {
                XxlJobLogger.log((String)("\u8fdc\u7a0b\u6587\u4ef6\u540d: " + fileName + " ,\u8fdc\u7a0b\u6587\u4ef6\u5927\u5c0f: " + fileSize), (Object[])new Object[0]);
                File file = (File)fileMaps.get(o.getName());
                XxlJobLogger.log((String)("\u7f13\u5b58\u6587\u4ef6\u540d: " + file.getName() + " ,\u7f13\u5b58\u6587\u4ef6\u5927\u5c0f: " + file.length()), (Object[])new Object[0]);
                XxlJobLogger.log((String)"\u5f53\u524d\u6587\u4ef6\u4e0a\u4f20\u6821\u9a8c-> \u6210\u529f", (Object[])new Object[0]);
                XxlJobLogger.log((String)("\u5220\u9664\u672c\u5730\u7f13\u5b58\u6587\u4ef6: " + file.delete()), (Object[])new Object[0]);
                XxlJobLogger.log((String)"---------------------------------------------------", (Object[])new Object[0]);
                successNum.getAndIncrement();
                successList.add(o.getName());
            }
        });
        XxlJobLogger.log((String)("-------------\u6210\u529f\u6570\u91cf: " + successNum.get()), (Object[])new Object[0]);
        allList.removeAll(successList);
        if (allList.size() > 0) {
            XxlJobLogger.log((String)("\u5931\u8d25\u6570\u91cf: " + allList.size()), (Object[])new Object[0]);
            XxlJobLogger.log((String)"\u5931\u8d25\u6587\u4ef6\u540d\u5217\u8868\u5982\u4e0b: ", (Object[])new Object[0]);
            allList.forEach(x$0 -> XxlJobLogger.log((String)x$0, (Object[])new Object[0]));
        }
        XxlJobLogger.log((String)("\u6240\u6709\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210,\u4e0a\u4f20\u6240\u8017\u65f6: " + FTPUtil.secondToTime((end - start) / 1000L)), (Object[])new Object[0]);
    }

    public static void PepsicoArUploadFile2Service(File cachePepsicoArFile, String ftpSavePath, AccountTemplateDO account) {
        if (!ftpSavePath.endsWith("/")) {
            ftpSavePath = ftpSavePath + "/";
        }
        String b_host = account.getSftpHost();
        String b_port = account.getSftpPort();
        String b_userName = account.getSftpUserName();
        String b_password = account.getSftpPassword();
        FTPClient pepsicoArFtpClient = null;
        try {
            pepsicoArFtpClient = FTPUtil.pepsicoCreate(b_host, Integer.parseInt(b_port), b_userName, b_password);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u8ba4\u8bc1 " + b_host + " \u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad"), (Object[])new Object[0]);
        }
        if (pepsicoArFtpClient != null) {
            try {
                long totalStart = System.currentTimeMillis();
                if (StringUtils.isNotEmpty((CharSequence)ftpSavePath)) {
                    File[] files = cachePepsicoArFile.listFiles();
                    AtomicInteger currentSize = new AtomicInteger(0);
                    assert (files != null);
                    for (File file : files) {
                        long currentStart = System.currentTimeMillis();
                        String oraFileName = file.getName();
                        int uploadIndex = oraFileName.lastIndexOf("#");
                        String uploadFileName = oraFileName.substring(uploadIndex + 1);
                        int index = oraFileName.lastIndexOf(".");
                        String suffix = oraFileName.substring(index);
                        String currentFileName = oraFileName.split(suffix)[0];
                        String[] splits = currentFileName.split("#");
                        String path = ftpSavePath;
                        for (int i = 0; i < splits.length - 1; ++i) {
                            pepsicoArFtpClient.changeWorkingDirectory(path);
                            String needCreatePath = splits[i];
                            pepsicoArFtpClient.makeDirectory(needCreatePath);
                            path = "/" + path + splits[i] + "/";
                            path = path.replace("//", "/");
                        }
                        currentSize.getAndIncrement();
                        try {
                            long currentEnd;
                            byte[] fileBytes = FTPUtil.getFileByteArray(file);
                            assert (fileBytes != null);
                            BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(fileBytes));
                            pepsicoArFtpClient.enterLocalPassiveMode();
                            pepsicoArFtpClient.changeWorkingDirectory(path);
                            pepsicoArFtpClient.setFileType(2);
                            pepsicoArFtpClient.setBufferSize(0x200000);
                            pepsicoArFtpClient.setDataTimeout(30000);
                            boolean isFlag = pepsicoArFtpClient.storeFile(uploadFileName, (InputStream)input);
                            if (isFlag) {
                                currentEnd = System.currentTimeMillis();
                                file.delete();
                                XxlJobLogger.log((String)("\u539f:" + file.getPath() + " ===> \u4e0a\u4f20:" + path + uploadFileName + "-------\u4e0a\u4f20\u6210\u529f ---------\u603b: " + files.length + ",\u5f53\u524d: " + currentSize + ",\u8017\u65f6:" + FTPUtil.secondToTime((currentEnd - currentStart) / 1000L)), (Object[])new Object[0]);
                                continue;
                            }
                            XxlJobLogger.log((String)(file.getPath() + "-------\u4e0a\u4f20\u5931\u8d25ERROR ---------\u603b: " + files.length + ",\u5f53\u524d: " + currentSize + ",\u6b63\u5728\u7b2c\u4e00\u6b21\u5c1d\u8bd5"), (Object[])new Object[0]);
                            byte[] fileBytes1 = FTPUtil.getFileByteArray(file);
                            assert (fileBytes1 != null);
                            BufferedInputStream input1 = new BufferedInputStream(new ByteArrayInputStream(fileBytes1));
                            boolean isFlag1 = pepsicoArFtpClient.storeFile(uploadFileName, (InputStream)input1);
                            if (isFlag1) {
                                currentEnd = System.currentTimeMillis();
                                file.delete();
                                XxlJobLogger.log((String)("\u539f:" + file.getPath() + " ===> \u4e0a\u4f20:" + path + uploadFileName + "-------\u7b2c\u4e00\u6b21\u5c1d\u8bd5\u4e0a\u4f20\u6210\u529f ---------\u603b: " + files.length + ",\u5f53\u524d: " + currentSize + ",\u8017\u65f6:" + FTPUtil.secondToTime((currentEnd - currentStart) / 1000L)), (Object[])new Object[0]);
                                continue;
                            }
                            XxlJobLogger.log((String)(file.getPath() + "-------\u5c1d\u8bd5\u4e0a\u4f20\u5931\u8d25ERROR ---------\u603b: " + files.length + ",\u5f53\u524d: " + currentSize + ",\u6b63\u5728\u7b2c\u4e8c\u6b21\u5c1d\u8bd5"), (Object[])new Object[0]);
                            FTPClient pepsicoArFtpClient1 = FTPUtil.pepsicoCreate(b_host, Integer.parseInt(b_port), b_userName, b_password);
                            byte[] fileBytes2 = FTPUtil.getFileByteArray(file);
                            assert (fileBytes2 != null);
                            BufferedInputStream input2 = new BufferedInputStream(new ByteArrayInputStream(fileBytes2));
                            assert (pepsicoArFtpClient1 != null);
                            pepsicoArFtpClient1.enterLocalPassiveMode();
                            pepsicoArFtpClient1.changeWorkingDirectory(path);
                            pepsicoArFtpClient1.setFileType(2);
                            pepsicoArFtpClient1.setBufferSize(0x200000);
                            pepsicoArFtpClient1.setDataTimeout(30000);
                            boolean isFlag2 = pepsicoArFtpClient1.storeFile(uploadFileName, (InputStream)input2);
                            if (isFlag2) {
                                currentEnd = System.currentTimeMillis();
                                file.delete();
                                XxlJobLogger.log((String)("\u539f:" + file.getPath() + " ===> \u4e0a\u4f20:" + path + uploadFileName + "-------\u7b2c\u4e8c\u6b21\u5c1d\u8bd5\u4e0a\u4f20\u6210\u529f ---------\u603b: " + files.length + ",\u5f53\u524d: " + currentSize + ",\u8017\u65f6:" + FTPUtil.secondToTime((currentEnd - currentStart) / 1000L)), (Object[])new Object[0]);
                                continue;
                            }
                            XxlJobLogger.log((String)(file.getPath() + " \u4e0a\u4f20\u5931\u8d25,\u6b64\u6587\u4ef6\u4e0a\u4f20\u4e22\u5931"), (Object[])new Object[0]);
                        }
                        catch (Exception e) {
                            XxlJobLogger.log((String)"\u7a0b\u5e8f\u5185\u90e8\u8fd0\u884c\u9519\u8bef,\u8054\u7cfb\u7ba1\u7406\u5458 : {}", (Object[])new Object[]{FTPUtil.getPrintExceptions(e)});
                            XxlJobLogger.log((String)(file.getName() + " - \u4e0a\u4f20\u6587\u4ef6\u7cfb\u7edf\u51fa\u9519,\u5f53\u524d\u6587\u4ef6\u4e22\u5931"), (Object[])new Object[0]);
                        }
                    }
                }
                long totalEnd = System.currentTimeMillis();
                XxlJobLogger.log((String)("\u6240\u6709\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210,\u4e0a\u4f20\u6240\u8017\u65f6: " + FTPUtil.secondToTime((totalEnd - totalStart) / 1000L)), (Object[])new Object[0]);
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u7a0b\u5e8f\u5185\u90e8\u8fd0\u884c\u9519\u8bef,\u8054\u7cfb\u7ba1\u7406\u5458 : {}", (Object[])new Object[]{FTPUtil.getPrintExceptions(e)});
                e.printStackTrace();
                return;
            }
        } else {
            XxlJobLogger.log((String)"\u672a\u83b7\u53d6\u94fe\u63a5", (Object[])new Object[0]);
            return;
        }
    }

    public static Boolean cacheMoveFile(AccountTemplateDO account, String ftpTargetPath, String ftpBackPath, String cacheTargetPath, String needDeletePath) throws Exception {
        String a_host = account.getSiteUrl();
        String a_port = account.getPort();
        String a_userName = account.getAccountName();
        String a_passWord = account.getAccountPassword();
        List<Object> connects = FTPUtil.getMustConnects(a_userName, a_host, Integer.parseInt(a_port), a_passWord);
        if (connects == null) {
            XxlJobLogger.log((String)("\u8ba4\u8bc1 " + a_host + " \u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad"), (Object[])new Object[0]);
            return false;
        }
        XxlJobLogger.log((String)"\u6b65\u9aa41.0 , \u6b63\u5728\u786e\u8ba4\u76ee\u6807\u76ee\u5f55\u548c\u5907\u4efd\u76ee\u5f55\u662f\u5426\u5b58\u5728...", (Object[])new Object[0]);
        ChannelSftp sftp0 = (ChannelSftp)connects.get(0);
        Channel channel0 = (Channel)connects.get(1);
        Session sshSession0 = (Session)connects.get(2);
        try {
            FTPUtil.createDir(ftpBackPath, sftp0);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u6b65\u9aa41.0, \u786e\u8ba4\u8def\u5f84\u5931\u8d25, \u5f53\u524d\u7ec8\u6b62\u4efb\u52a1", (Object[])new Object[0]);
            return false;
        }
        ArrayList<String> fullFileNames = new ArrayList<String>();
        XxlJobLogger.log((String)"\u64cd\u4f5c2.0, \u83b7\u53d6\u6587\u4ef6\u540d...", (Object[])new Object[0]);
        try {
            List<String> ls = FTPUtil.cacheMoveFileGetLs(connects, ftpTargetPath);
            fullFileNames.addAll(ls);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u6b65\u9aa42.0, \u83b7\u53d6\u6587\u4ef6\u540d\u5931\u8d25, \u5f53\u524d\u7ec8\u6b62\u4efb\u52a1", (Object[])new Object[0]);
            return false;
        }
        XxlJobLogger.log((String)"\u64cd\u4f5c3.0, \u5c06\u6587\u4ef6\u7f13\u5b58\u81f3\u672c\u5730...", (Object[])new Object[0]);
        for (String fileName : fullFileNames) {
            try {
                FTPUtil.download2(connects, ftpTargetPath, cacheTargetPath);
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u6b65\u9aa43.0, \u6587\u4ef6\u7f13\u5b58\u5931\u8d25, \u5f53\u524d\u7ec8\u6b62\u4efb\u52a1", (Object[])new Object[0]);
                return false;
            }
        }
        XxlJobLogger.log((String)"\u6b65\u9aa44.0, \u5c06\u6587\u4ef6\u8fdb\u884c\u5907\u4efd...", (Object[])new Object[0]);
        for (String fileName : fullFileNames) {
            try {
                boolean rename = FTPUtil.rename(connects, ftpTargetPath + "/" + fileName, ftpBackPath + "/" + fileName);
                if (rename) {
                    XxlJobLogger.log((String)(ftpTargetPath + "/" + fileName + " --->\u5907\u4efd\u81f3---> " + ftpBackPath + "/" + fileName + " --> \u6210\u529f"), (Object[])new Object[0]);
                    continue;
                }
                XxlJobLogger.log((String)(ftpTargetPath + "/" + fileName + " ---> \u5907\u4efd\u5931\u8d25"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u6b65\u9aa44.0, \u6587\u4ef6\u5907\u4efd\u5931\u8d25, \u5f53\u524d\u7ec8\u6b62\u4efb\u52a1", (Object[])new Object[0]);
                return false;
            }
        }
        if (fullFileNames.size() == 0) {
            ChannelSftp sftpChannel = (ChannelSftp)connects.get(0);
            sftpChannel.rmdir(ftpBackPath);
            sftpChannel.rmdir(needDeletePath);
        }
        if (connects.size() == 3) {
            FTPUtil.closeChannel((Channel)sftp0);
            FTPUtil.closeChannel(channel0);
            FTPUtil.closeSession(sshSession0);
        }
        return true;
    }

    public static void uploadMoveFile(AccountTemplateDO account, String ftpSavePath, String cacheTargetPath) throws Exception {
        String b_host = account.getSftpHost();
        String b_port = account.getSftpPort();
        String b_userName = account.getSftpUserName();
        String b_password = account.getSftpPassword();
        List<Object> connects = FTPUtil.getMustConnects(b_userName, b_host, Integer.parseInt(b_port), b_password);
        if (connects == null) {
            XxlJobLogger.log((String)"\u83b7\u53d6\u94fe\u63a5\u5931\u8d25", (Object[])new Object[0]);
            return;
        }
        ChannelSftp sftp0 = (ChannelSftp)connects.get(0);
        Channel channel0 = (Channel)connects.get(1);
        Session sshSession0 = (Session)connects.get(2);
        List<String> allFile = FTPUtil.getAllFile(cacheTargetPath, false);
        sftp0.cd(ftpSavePath);
        block4: for (String fileName : allFile) {
            File file = new File(fileName);
            FileInputStream fileStream = new FileInputStream(file);
            String splitStr = "";
            if (OsInfo.isWindows()) {
                fileName = fileName.replace("\\", "/");
                splitStr = "/";
            } else {
                splitStr = "/";
            }
            String mergeStr = "/";
            String[] splits = fileName.split(splitStr);
            int length = splits.length;
            String split = splits[length - 1];
            String split1 = splits[length - 2];
            String split2 = splits[length - 3];
            String filePath = ftpSavePath + mergeStr + split2;
            String filePath1 = ftpSavePath + mergeStr + split2 + mergeStr + split1.toUpperCase();
            try {
                sftp0.mkdir(filePath);
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
            try {
                sftp0.mkdir(filePath1);
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
            String saveName = ftpSavePath + mergeStr + split2 + mergeStr + split1.toUpperCase() + mergeStr + split;
            sftp0.put((InputStream)fileStream, saveName);
            Vector files = sftp0.ls(saveName);
            for (ChannelSftp.LsEntry lsEntry : files) {
                String filename = lsEntry.getFilename();
                if (!saveName.contains(filename)) continue;
                XxlJobLogger.log((String)(filename + "-\u4e0a\u4f20\u6210\u529f"), (Object[])new Object[0]);
                ((InputStream)fileStream).close();
                file.delete();
                continue block4;
            }
        }
        FTPUtil.closeChannel((Channel)sftp0);
        FTPUtil.closeChannel(channel0);
        FTPUtil.closeSession(sshSession0);
    }

    public static List<String> getAllFile(String directoryPath, boolean isAddDirectory) {
        ArrayList<String> list = new ArrayList<String>();
        File baseFile = new File(directoryPath);
        if (baseFile.isFile() || !baseFile.exists()) {
            return list;
        }
        File[] files = baseFile.listFiles();
        assert (files != null);
        for (File file : files) {
            if (file.isDirectory()) {
                if (isAddDirectory) {
                    list.add(file.getAbsolutePath());
                }
                list.addAll(FTPUtil.getAllFile(file.getAbsolutePath(), isAddDirectory));
                continue;
            }
            list.add(file.getAbsolutePath());
        }
        return list;
    }

    public static Boolean PepsicoArCacheFile2Local(AccountTemplateDO account, String ftap, String ctp) {
        ftap = ftap.startsWith("/") ? ftap : "/" + ftap;
        String sftpHost = account.getSftpHost();
        String sftpPort = account.getSftpPort();
        String sftpUserName = account.getSftpUserName();
        String sftpPassword = account.getSftpPassword();
        XxlJobLogger.log((String)("\u6b63\u5728\u64cd\u4f5c: " + sftpHost), (Object[])new Object[0]);
        FTPClient ftp = null;
        try {
            TimeUnit.SECONDS.sleep(3L);
            ftp = FTPUtil.pepsicoCreate(sftpHost, Integer.parseInt(sftpPort), sftpUserName, sftpPassword);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u8ba4\u8bc1 " + sftpHost + " \u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad"), (Object[])new Object[0]);
            return false;
        }
        if (ftp != null) {
            try {
                XxlJobLogger.log((String)("\u6b63\u5728\u626b\u63cf " + ftap + " \u4e0b\u7684\u6587\u4ef6,\u8bf7\u7a0d\u540e...."), (Object[])new Object[0]);
                TimeUnit.SECONDS.sleep(3L);
                ftp.setFileType(2);
                ftp.enterLocalPassiveMode();
                ftp.changeWorkingDirectory(ftap);
                FTPFile[] files = ftp.listFiles();
                List<String> list = FTPUtil.pepsicoArCacheFile2LocalGetAllFile(files, ftap, ftp);
                for (String s : list) {
                    int i = s.lastIndexOf("/");
                    String p = s.substring(0, i);
                    String n = s.substring(i + 1);
                    String ftap1 = ftap.endsWith("/") ? ftap : ftap + "/";
                    String rn = s.startsWith("/") ? s.replace(ftap1, "").replace("/", "#") : s.replace(ftap1.substring(1), "").replace("/", "#");
                    FTPUtil.PepsicoArCacheFileLocalDownLoad(ftp, p, n, rn, ctp);
                    boolean b = ftp.deleteFile(s);
                    if (b) {
                        XxlJobLogger.log((String)("\u5df2\u5220\u9664\u8be5\u6587\u4ef6: " + s), (Object[])new Object[0]);
                        continue;
                    }
                    XxlJobLogger.log((String)"\u5220\u9664\u6587\u4ef6\u5931\u8d25", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                XxlJobLogger.log((String)e.getMessage(), (Object[])new Object[0]);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static List<String> pepsicoArCacheFile2LocalGetAllFile(FTPFile[] files, String ftap, FTPClient ftp) {
        ArrayList<String> af = new ArrayList<String>();
        try {
            for (FTPFile file : files) {
                String name = file.getName();
                if (!name.startsWith("10") && !name.startsWith("20") && !name.startsWith("30")) continue;
                FTPUtil.pepsicoArCacheFile2LocalList(ftap + "/" + name + "/", ftp, af);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return af;
    }

    public static void pepsicoArCacheFile2LocalList(String pn, FTPClient ftp, List<String> arf) throws IOException {
        if (pn.startsWith("/") && pn.endsWith("/")) {
            FTPFile[] files;
            String directory = pn;
            ftp.changeWorkingDirectory(directory);
            for (FTPFile file : files = ftp.listFiles()) {
                if (file.isFile()) {
                    String s = directory + file.getName();
                    if (!s.contains("88 PowerE2E")) continue;
                    arf.add(s);
                    continue;
                }
                if (!file.isDirectory()) continue;
                FTPUtil.pepsicoArCacheFile2LocalList(directory + file.getName() + "/", ftp, arf);
            }
        }
    }

    public static boolean PepsicoArCacheFileLocalDownLoad(FTPClient ftp, String filePath, String fileName, String rn, String downPath) {
        boolean flag = false;
        try {
            ftp.changeWorkingDirectory(filePath);
            ftp.enterLocalPassiveMode();
            FTPFile[] files = ftp.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().equals(fileName)) continue;
                File downFile = new File(downPath + File.separator + rn);
                FileOutputStream out = new FileOutputStream(downFile);
                flag = ftp.retrieveFile(new String(files[i].getName().getBytes("UTF-8"), "ISO-8859-1"), (OutputStream)out);
                out.flush();
                ((OutputStream)out).close();
                if (flag) {
                    int index = i + 1;
                    XxlJobLogger.log((String)("\u4e0b\u8f7d\u6587\u4ef6" + index + ": " + rn), (Object[])new Object[0]);
                    continue;
                }
                logger.error("\u4e0b\u8f7d\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u4e0b\u8f7d\u5931\u8d25");
        }
        return flag;
    }

    public static void PepsicoArUploadFile2Service(AccountTemplateDO account, String ftpSavePath, String cacheTargetPath, String ftpBackPath) {
        block13: {
            String a_host = account.getSiteUrl();
            String a_port = account.getPort();
            String a_userName = account.getAccountName();
            String a_password = account.getAccountPassword();
            XxlJobLogger.log((String)("\u6b63\u5728\u64cd\u4f5c: " + a_host), (Object[])new Object[0]);
            try {
                File[] files;
                List<Object> connects = FTPUtil.getMustConnects(a_userName, a_host, Integer.parseInt(a_port), a_password);
                assert (connects != null);
                ChannelSftp sftpChannel = (ChannelSftp)connects.get(0);
                Channel channel = (Channel)connects.get(1);
                Session session = (Session)connects.get(2);
                if (connects.size() != 3) break block13;
                XxlJobLogger.log((String)"\u6b65\u9aa41.0, \u6b63\u5728\u786e\u8ba4\u5b58\u50a8\u8def\u5f84\u662f\u5426\u5b58\u5728...", (Object[])new Object[0]);
                try {
                    FTPUtil.createDir(ftpSavePath, sftpChannel);
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)"\u5f53\u524d\u8def\u5f84\u5df2\u5b58\u5728", (Object[])new Object[0]);
                }
                XxlJobLogger.log((String)"\u6b65\u9aa41.1, \u6b63\u5728\u786e\u8ba4\u5907\u4efd\u8def\u5f84\u662f\u5426\u5b58\u5728...", (Object[])new Object[0]);
                try {
                    FTPUtil.createDir(ftpBackPath, sftpChannel);
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)"\u5f53\u524d\u8def\u5f84\u5df2\u5b58\u5728", (Object[])new Object[0]);
                }
                XxlJobLogger.log((String)"\u6b63\u5728\u5907\u4efd\u6587\u4ef6, \u8bf7\u7a0d\u540e...", (Object[])new Object[0]);
                File file = new File(cacheTargetPath);
                if (file.isDirectory()) {
                    files = file.listFiles();
                    assert (files != null);
                    for (File file1 : files) {
                        if (!file1.isFile()) continue;
                        FTPUtil.uploadFileVersionLevel(file1, ftpBackPath, connects, account);
                    }
                }
                XxlJobLogger.log((String)"\u6b65\u9aa42.0, \u6b63\u5728\u5c06\u6587\u4ef6\u4e0a\u4f20, \u8bf7\u7a0d\u540e...", (Object[])new Object[0]);
                if (file.isDirectory()) {
                    for (File file1 : files = file.listFiles()) {
                        if (file1.isFile()) {
                            FTPUtil.uploadFileVersionLevel(file1, ftpSavePath, connects, account);
                        }
                        file1.delete();
                    }
                }
                FTPUtil.closeChannel((Channel)sftpChannel);
                FTPUtil.closeChannel(channel);
                FTPUtil.closeSession(session);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void uploadFileShare(String sourceFileName, String destFileName, Integer total, AtomicInteger currentSize, String printFileName, AzurePepsicoProperties properties) {
        if (sourceFileName != null && destFileName != null) {
            try {
                ShareFileClient shareClient = new ShareFileClientBuilder().endpoint(FTPUtil.getStorageConnectionString(properties)).sasToken(properties.getSasToken()).shareName(properties.getShareName()).resourcePath(destFileName).buildFileClient();
                File file = new File(sourceFileName);
                shareClient.create(file.length());
                try {
                    shareClient.uploadFromFile(sourceFileName);
                    boolean flag = file.delete();
                    TimeUnit.SECONDS.sleep(3L);
                    XxlJobLogger.log((String)(printFileName + "------\u4e0a\u4f20\u6210\u529f ----------\u603b: " + total + ",\u5f53\u524d: " + currentSize + ",\u5220\u9664\u672c\u5730\u7f13\u5b58\u6587\u4ef6:" + flag), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    Integer n = errorTimes;
                    Integer n2 = errorTimes = Integer.valueOf(errorTimes + 1);
                    if (errorTimes > 10) {
                        return;
                    }
                    e.printStackTrace();
                    XxlJobLogger.log((String)("Failed to upload the data. Reasons: " + e.getMessage()), (Object[])new Object[0]);
                    XxlJobLogger.log((String)(printFileName + "------\u4e0a\u4f20\u5931\u8d25,\u6b63\u5728\u5c1d\u8bd5\u91cd\u8bd5 ----------\u603b: " + total + ",\u5f53\u524d: " + currentSize), (Object[])new Object[0]);
                    TimeUnit.SECONDS.sleep(3L);
                    FTPUtil.uploadFileShare(sourceFileName, destFileName, total, currentSize, printFileName, properties);
                }
            }
            catch (Exception e) {
                Integer n = errorTimes;
                Integer n3 = errorTimes = Integer.valueOf(errorTimes + 1);
                if (errorTimes > 10) {
                    return;
                }
                e.printStackTrace();
                XxlJobLogger.log((String)("Failed to connect files from file share: " + e.getMessage()), (Object[])new Object[0]);
                XxlJobLogger.log((String)(printFileName + "------\u4e0a\u4f20\u5931\u8d25,\u6b63\u5728\u5c1d\u8bd5\u91cd\u8bd5 ----------\u603b: " + total + ",\u5f53\u524d: " + currentSize), (Object[])new Object[0]);
                FTPUtil.uploadFileShare(sourceFileName, destFileName, total, currentSize, printFileName, properties);
            }
        }
    }

    private static String getStorageConnectionString(AzurePepsicoProperties properties) {
        return String.format(properties.getEndPoint(), properties.getAccountName());
    }

    private static String secondToTime(long second) {
        long days = second / 86400L;
        long hours = (second %= 86400L) / 3600L;
        long minutes = (second %= 3600L) / 60L;
        second %= 60L;
        if (0L < days) {
            return days + "\u5929\uff0c" + hours + "\u5c0f\u65f6\uff0c" + minutes + "\u5206\uff0c" + second + "\u79d2";
        }
        return hours + "\u5c0f\u65f6 " + minutes + "\u5206 " + second + "\u79d2 ";
    }

    public static void uploadFile(String fileName, String originPath, AccountTemplateDO account) {
        List<Object> connects;
        try {
            String a_host = account.getSftpHost();
            int a_port = Integer.parseInt(account.getSftpPort());
            String a_userName = account.getSftpUserName();
            String a_passWord = account.getSftpPassword();
            connects = FTPUtil.getMustConnects(a_userName, a_host, a_port, a_passWord);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u4f20\u8f93\u6587\u4ef6\u94fe\u63a5\u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad", (Object[])new Object[0]);
            XxlJobLogger.log((Throwable)e);
            return;
        }
        FTPUtil.createDir(originPath, (ChannelSftp)connects.get(0));
        FTPUtil.uploadFileVersionLevel(new File(fileName), originPath, connects, account);
        try {
            if (connects != null) {
                ChannelSftp channelSftp = (ChannelSftp)connects.get(0);
                Channel channel = (Channel)connects.get(1);
                Session sshSession = (Session)connects.get(2);
                channelSftp.quit();
                channelSftp.disconnect();
                channel.disconnect();
                sshSession.disconnect();
                XxlJobLogger.log((String)"close pipeline", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"close pipeline exception", (Object[])new Object[0]);
        }
    }

    public static void uploadPepsicoAR(File file, String ftpSavePath, String host, int port, String userName, String password, AccountTemplateDO account) {
        Object[] fs;
        if (!ftpSavePath.endsWith("/")) {
            ftpSavePath = ftpSavePath + "/";
        }
        if (!ObjectUtils.isEmpty((Object[])(fs = file.listFiles()))) {
            List<Object> connects;
            try {
                connects = FTPUtil.getMustConnects(userName, host, port, password);
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u4f20\u8f93\u6587\u4ef6\u94fe\u63a5\u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad", (Object[])new Object[0]);
                return;
            }
            for (Object f : fs) {
                String oraFileName = ((File)f).getName();
                int uploadIndex = oraFileName.lastIndexOf("#");
                String uploadFileName = oraFileName.substring(uploadIndex + 1);
                String currentFilePath = oraFileName.split(uploadFileName)[0].replaceAll("#", "/");
                String originPath = ftpSavePath + currentFilePath;
                FTPUtil.createDir(originPath, (ChannelSftp)connects.get(0));
                FTPUtil.uploadFileSFTP((File)f, originPath, uploadFileName, connects, account);
            }
            try {
                if (connects != null) {
                    ChannelSftp channelSftp = (ChannelSftp)connects.get(0);
                    Channel channel = (Channel)connects.get(1);
                    Session sshSession = (Session)connects.get(2);
                    channelSftp.quit();
                    channelSftp.disconnect();
                    channel.disconnect();
                    sshSession.disconnect();
                    XxlJobLogger.log((String)"close pipeline", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"close pipeline exception", (Object[])new Object[0]);
                XxlJobLogger.log((Throwable)e);
            }
        }
    }

    public static void uploadFileSFTP(File localFile, String originPath, String fileName, List<Object> connects, AccountTemplateDO account) {
        if (connects != null) {
            ChannelSftp channelSftp = (ChannelSftp)connects.get(0);
            try {
                boolean bool = FTPUtil.upLoadFile(originPath, fileName, FTPUtil.getFileByteArray(localFile), channelSftp, account);
                if (bool) {
                    boolean result = localFile.delete();
                    XxlJobLogger.log((String)("\u5220\u9664\u7f13\u5b58\u7ed3\u679c file:" + localFile.getAbsolutePath() + " result:" + result), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38, \u6b63\u5728\u5c1d\u8bd5\u91cd\u8bd5: {}", (Object[])new Object[]{FTPUtil.getPrintExceptions(e)});
                XxlJobLogger.log((Throwable)e);
                try {
                    boolean bool = FTPUtil.upLoadFile(originPath, fileName, FTPUtil.getFileByteArray(localFile), channelSftp, account);
                    if (bool) {
                        boolean result = localFile.delete();
                        XxlJobLogger.log((String)("\u5220\u9664\u7f13\u5b58\u7ed3\u679c file:" + localFile.getAbsolutePath() + " result:" + result), (Object[])new Object[0]);
                    }
                }
                catch (Exception exception) {
                    XxlJobLogger.log((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38, \u6b63\u5728\u5c1d\u8bd5\u91cd\u8bd5: {}", (Object[])new Object[]{FTPUtil.getPrintExceptions(e)});
                    XxlJobLogger.log((Throwable)e);
                }
            }
        } else {
            XxlJobLogger.log((String)"\u672a\u83b7\u53d6\u94fe\u63a5", (Object[])new Object[0]);
        }
    }

    public static Boolean downloadPepsicoAR(String host, String port, String userName, String passWord, String ftap, String ctp) {
        ftap = ftap.startsWith("/") ? ftap : "/" + ftap;
        List<Object> connects = null;
        try {
            connects = FTPUtil.getMustConnects(userName, host, Integer.parseInt(port), passWord);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (connects == null) {
            XxlJobLogger.log((String)("\u8ba4\u8bc1 " + host + " \u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad"), (Object[])new Object[0]);
            return false;
        }
        XxlJobLogger.log((String)"\u6b65\u9aa41.0 , \u6b63\u5728\u786e\u8ba4\u76ee\u6807\u76ee\u5f55\u548c\u5907\u4efd\u76ee\u5f55\u662f\u5426\u5b58\u5728...", (Object[])new Object[0]);
        ChannelSftp sftpChannel = (ChannelSftp)connects.get(0);
        Channel channel = (Channel)connects.get(1);
        Session session = (Session)connects.get(2);
        ArrayList<String> fullFileNames = new ArrayList<String>();
        XxlJobLogger.log((String)"\u64cd\u4f5c2.0, \u83b7\u53d6\u6587\u4ef6\u540d...", (Object[])new Object[0]);
        try {
            FTPUtil.pepsicoArCacheFile(connects, ftap, fullFileNames);
            if (fullFileNames.size() == 0) {
                XxlJobLogger.log((String)"\u64cd\u4f5c2.0 - ls \u4e3a\u7a7a, \u6b64\u6b21\u4efb\u52a1\u7ec8\u6b62", (Object[])new Object[0]);
                return false;
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u64cd\u4f5c2.0 - \u9519\u8bef,\u6b64\u6b21\u4efb\u52a1\u7ec8\u6b62(500-\u7a0b\u5e8f\u5185\u90e8\u51fa\u9519)", (Object[])new Object[0]);
            return false;
        }
        XxlJobLogger.log((String)"\u64cd\u4f5c3.0, \u5c06\u6587\u4ef6\u7f13\u5b58\u81f3\u672c\u5730...", (Object[])new Object[0]);
        for (String s : fullFileNames) {
            int i = s.lastIndexOf("/");
            String p = s.substring(0, i);
            String n = s.substring(i + 1);
            String ftap1 = ftap.endsWith("/") ? ftap : ftap + "/";
            String rn = s.startsWith("/") ? s.replace(ftap1, "").replace("/", "#") : s.replace(ftap1.substring(1), "").replace("/", "#");
            try {
                FTPUtil.download(connects, p, n, ctp, rn);
                XxlJobLogger.log((String)(s + " --\u7f13\u5b58\u672c\u5730\u6210\u529f"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (connects.size() == 3) {
            FTPUtil.closeChannel((Channel)sftpChannel);
            FTPUtil.closeChannel(channel);
            FTPUtil.closeSession(session);
        }
        return true;
    }

    public static Boolean downloadPepsicoAR(String host, String port, String userName, String passWord, List<String> pathList, String ctp, String ftap) {
        List<Object> connects = null;
        try {
            connects = FTPUtil.getMustConnects(userName, host, Integer.parseInt(port), passWord);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (connects == null) {
            XxlJobLogger.log((String)("\u8ba4\u8bc1 " + host + " \u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad"), (Object[])new Object[0]);
            return false;
        }
        XxlJobLogger.log((String)"\u6b65\u9aa41.0 , \u6b63\u5728\u786e\u8ba4\u76ee\u6807\u76ee\u5f55\u548c\u5907\u4efd\u76ee\u5f55\u662f\u5426\u5b58\u5728...", (Object[])new Object[0]);
        ChannelSftp sftpChannel = (ChannelSftp)connects.get(0);
        Channel channel = (Channel)connects.get(1);
        Session session = (Session)connects.get(2);
        try {
            session.setServerAliveInterval(600);
        }
        catch (JSchException e) {
            return false;
        }
        ArrayList fullFileNames = new ArrayList();
        XxlJobLogger.log((String)"\u64cd\u4f5c2.0, \u83b7\u53d6\u6587\u4ef6\u540d...", (Object[])new Object[0]);
        try {
            for (String path : pathList) {
                List<String> ls = FTPUtil.cacheMoveFileGetLs(connects, path);
                if (ls == null || ls.isEmpty()) continue;
                ls.forEach(name -> fullFileNames.add(path.concat((String)name)));
            }
            if (fullFileNames.size() == 0) {
                XxlJobLogger.log((String)"\u64cd\u4f5c2.0 - ls \u4e3a\u7a7a, \u6b64\u6b21\u4efb\u52a1\u7ec8\u6b62", (Object[])new Object[0]);
                return false;
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u64cd\u4f5c2.0 - \u9519\u8bef,\u6b64\u6b21\u4efb\u52a1\u7ec8\u6b62(500-\u7a0b\u5e8f\u5185\u90e8\u51fa\u9519)", (Object[])new Object[0]);
            return false;
        }
        XxlJobLogger.log((String)"\u64cd\u4f5c3.0, \u5c06\u6587\u4ef6\u7f13\u5b58\u81f3\u672c\u5730...", (Object[])new Object[0]);
        for (String s : fullFileNames) {
            int i = s.lastIndexOf("/");
            String p = s.substring(0, i);
            String n = s.substring(i + 1);
            String ftap1 = ftap.endsWith("/") ? ftap : ftap + "/";
            String rn = s.startsWith("/") ? s.replace(ftap1, "").replace("/", "#") : s.replace(ftap1.substring(1), "").replace("/", "#");
            try {
                FTPUtil.download(connects, p, n, ctp, rn);
                XxlJobLogger.log((String)(s + " --\u7f13\u5b58\u672c\u5730\u6210\u529f"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (connects.size() == 3) {
            FTPUtil.closeChannel((Channel)sftpChannel);
            FTPUtil.closeChannel(channel);
            FTPUtil.closeSession(session);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(List<Object> allConnect, String directory, String downloadFile, String saveDirectory, String saveFileName) throws Exception {
        ChannelSftp sftpChannel = (ChannelSftp)allConnect.get(0);
        try (FileOutputStream fileOutputStream = null;){
            String saveFile = saveDirectory + "/" + saveFileName;
            sftpChannel.cd(directory);
            File file = new File(saveFile);
            fileOutputStream = new FileOutputStream(file);
            sftpChannel.get(downloadFile, (OutputStream)fileOutputStream);
            sftpChannel.rm(downloadFile);
        }
    }

    private static void pepsicoArCacheFile(List<Object> connects, String ftap, List<String> af) {
        List<String> files = FTPUtil.cacheMoveFileGetLs(connects, ftap);
        try {
            for (String name : files) {
                if (!name.startsWith("10") && !name.startsWith("20") && !name.startsWith("30")) continue;
                FTPUtil.pepsicoArCacheFileList(ftap + "/" + name + "/", (ChannelSftp)connects.get(0), af);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void pepsicoArCacheFileList(String path, ChannelSftp channelSftp, List<String> af) {
        try {
            Vector fileList = channelSftp.ls(path);
            for (ChannelSftp.LsEntry file : fileList) {
                if (".".equals(file.getFilename()) || "..".equals(file.getFilename())) continue;
                if (file.getAttrs().isDir()) {
                    FTPUtil.pepsicoArCacheFileList(path + file.getFilename() + "/", channelSftp, af);
                    continue;
                }
                String s = path + file.getFilename();
                if (!s.contains("88 PowerE2E")) continue;
                af.add(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ReturnT<String> uploadFilePath(File localFile, String originPath, AccountTemplateDO account) {
        List<Object> connects;
        if (FileUtil.isDirectoryList(localFile).booleanValue()) {
            List fileList1 = (List)FileUtils.listFiles((File)localFile, null, (boolean)true);
            XxlJobLogger.log((String)"\u539f\u76ee\u5f55\u4e0b\u6709\u5b50\u76ee\u5f55\u51c6\u5907\u6253\u6210zip\u5305", (Object[])new Object[0]);
            if (!fileList1.isEmpty() && fileList1.size() >= 1) {
                String suffix = account.getFileSuffix();
                String projectKey = account.getProjectKey();
                String retailKey = account.getRetailKey();
                ArrayList<String> fileList = new ArrayList<String>();
                String cacheTargetPath = CommonConfig.DCS_FILE_ROOT_PATH + File.separator + "cachezip" + File.separator + projectKey + File.separator + retailKey;
                File file = new File(cacheTargetPath);
                if (!file.exists()) {
                    boolean bl = file.mkdirs();
                    XxlJobLogger.log((String)("\u521b\u5efa\u672c\u673a\u7f13\u5b58\u76ee\u5f55\uff1a " + file.getAbsolutePath() + " result:" + bl), (Object[])new Object[0]);
                    if (!bl) {
                        return ReturnT.FAIL;
                    }
                }
                String string = cacheTargetPath + File.separator + projectKey + "_" + retailKey + "-" + System.currentTimeMillis() + ".zip";
                XxlJobLogger.log((String)("zip\u5305\u8def\u5f84\uff1a" + string), (Object[])new Object[0]);
                XxlJobLogger.log((String)("localFile\u8def\u5f84\uff1a" + localFile.getAbsolutePath()), (Object[])new Object[0]);
                CreateFilesZip.createZip(localFile.getAbsolutePath(), string, suffix, fileList);
                localFile = new File(cacheTargetPath);
                if (!fileList.isEmpty() && StringUtils.isNotBlank((CharSequence)account.getFtpBackPath())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String ftpBackPath = account.getFtpBackPath() + "/" + sdf.format(new Date());
                    for (String fileName : fileList) {
                        boolean bool;
                        String backPath = ftpBackPath + fileName.substring(0, fileName.lastIndexOf(File.separator));
                        File backFile = new File(backPath);
                        if (!backFile.exists()) {
                            backFile.mkdirs();
                        }
                        if (!(bool = new File(fileName).renameTo(new File(ftpBackPath + fileName)))) continue;
                        XxlJobLogger.log((String)(fileName + " --->\u5907\u4efd\u81f3---> " + ftpBackPath + "/" + fileName + " --> \u6210\u529f"), (Object[])new Object[0]);
                    }
                }
                fileList.clear();
            } else {
                XxlJobLogger.log((String)"localPath\u76ee\u5f55\u4e0b\u6ca1\u6709\u5f85\u4e0a\u4f20\u6587\u4ef6", (Object[])new Object[0]);
                return ReturnT.SUCCESS;
            }
        }
        List<Object> fs = Arrays.asList((Object[])Objects.requireNonNull(localFile.listFiles(pathname -> pathname.exists() && pathname.isFile())));
        Collections.sort(fs, (o1, o2) -> {
            try {
                return Files.getLastModifiedTime(o1.toPath(), new LinkOption[0]).compareTo(Files.getLastModifiedTime(o2.toPath(), new LinkOption[0]));
            }
            catch (IOException e) {
                XxlJobLogger.log((String)"sort list error", (Object[])new Object[0]);
                return 0;
            }
        });
        if (fs.isEmpty()) {
            XxlJobLogger.log((String)"localPath\u76ee\u5f55\u4e0b\u6ca1\u6709\u5f85\u4e0a\u4f20\u6587\u4ef6", (Object[])new Object[0]);
            return ReturnT.SUCCESS;
        }
        try {
            String a_host = account.getSftpHost();
            int a_port = Integer.parseInt(account.getSftpPort());
            String a_userName = account.getSftpUserName();
            String a_passWord = account.getSftpPassword();
            connects = FTPUtil.getMustConnects(a_userName, a_host, a_port, a_passWord);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u4f20\u8f93\u6587\u4ef6\u94fe\u63a5\u5931\u8d25, \u6b64\u6b21\u4e2d\u65ad", (Object[])new Object[0]);
            XxlJobLogger.log((Throwable)e);
            return ReturnT.FAIL;
        }
        XxlJobLogger.log((String)"\u5f00\u59cb\u4e0a\u4f20\u300b\u300b\u300b\u300b\u300b", (Object[])new Object[0]);
        XxlJobLogger.log((String)("localPath\u76ee\u5f55\u6587\u4ef6\u6570\uff1a" + fs.size()), (Object[])new Object[0]);
        if (!FTPUtil.createDir(originPath, (ChannelSftp)connects.get(0))) {
            return ReturnT.FAIL;
        }
        int i = 0;
        int succ = 0;
        int fail = 0;
        int times = 15;
        for (File file : fs) {
            if (!file.isFile()) continue;
            XxlJobLogger.log((String)("\u6b63\u5728\u5904\u7406\u6587\u4ef6:" + file.getAbsolutePath()), (Object[])new Object[0]);
            boolean b = FTPUtil.uploadFileVersionLevel(file, originPath, connects, account);
            if (!b) {
                ++i;
                ++fail;
            } else {
                i = 0;
                ++succ;
            }
            if (i < times) continue;
            XxlJobLogger.log((String)("\u8fde\u7eed\u5931\u8d25" + times + "\u6b21\uff0c\u9000\u51fa\u672c\u6b21\u4efb\u52a1"), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        XxlJobLogger.log((String)("\u603b\u6570:" + fs.size() + " \u6210\u529f:" + succ + " \u5931\u8d25:" + fail), (Object[])new Object[0]);
        try {
            if (connects != null) {
                ChannelSftp channelSftp = (ChannelSftp)connects.get(0);
                Channel channel = (Channel)connects.get(1);
                Session sshSession = (Session)connects.get(2);
                channelSftp.quit();
                channelSftp.disconnect();
                channel.disconnect();
                sshSession.disconnect();
                XxlJobLogger.log((String)"close pipeline", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"close pipeline exception", (Object[])new Object[0]);
            XxlJobLogger.log((Throwable)e);
        }
        return fail == 0 ? ReturnT.SUCCESS : ReturnT.FAIL;
    }

    static {
        errorTimes = 0;
    }
}

