/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xuxueli.crawler.annotation.PageFieldSelect;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public final class FieldReflectionUtil {
    private FieldReflectionUtil() {
    }

    public static Byte parseByte(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Byte.valueOf(value);
        }
        catch (NumberFormatException var2) {
            throw new RuntimeException("parseByte but input illegal input=" + value, var2);
        }
    }

    public static Boolean parseBoolean(String value) {
        value = value.replaceAll("\u3000", "");
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        throw new RuntimeException("parseBoolean but input illegal input=" + value);
    }

    public static Integer parseInt(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Integer.valueOf(value);
        }
        catch (NumberFormatException var2) {
            throw new RuntimeException("parseInt but input illegal input=" + value, var2);
        }
    }

    public static Short parseShort(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Short.valueOf(value);
        }
        catch (NumberFormatException var2) {
            throw new RuntimeException("parseShort but input illegal input=" + value, var2);
        }
    }

    public static Long parseLong(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Long.valueOf(value);
        }
        catch (NumberFormatException var2) {
            throw new RuntimeException("parseLong but input illegal input=" + value, var2);
        }
    }

    public static Float parseFloat(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Float.valueOf(value);
        }
        catch (NumberFormatException var2) {
            throw new RuntimeException("parseFloat but input illegal input=" + value, var2);
        }
    }

    public static Double parseDouble(String value) {
        try {
            value = value.replaceAll("\u3000", "");
            return Double.valueOf(value);
        }
        catch (NumberFormatException var2) {
            throw new RuntimeException("parseDouble but input illegal input=" + value, var2);
        }
    }

    public static Date parseDate(PageFieldSelect apiRequestParam, String value) {
        try {
            String datePattern = "yyyy-MM-dd HH:mm:ss";
            if (apiRequestParam != null) {
                datePattern = apiRequestParam.datePattern();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
            return dateFormat.parse(value);
        }
        catch (ParseException var4) {
            throw new RuntimeException("parseDate but input illegal input=" + value, var4);
        }
    }

    public static Object parseValue(Field field, String value) {
        ParameterizedType fieldGenericType;
        Class fieldType = field.getType();
        if (field.getGenericType() instanceof ParameterizedType && (fieldGenericType = (ParameterizedType)field.getGenericType()).getRawType().equals(List.class)) {
            Type gtATA = fieldGenericType.getActualTypeArguments()[0];
            fieldType = (Class)gtATA;
        }
        PageFieldSelect apiRequestParam = field.getAnnotation(PageFieldSelect.class);
        if (value != null && value.trim().length() != 0) {
            value = value.trim();
            if (!Byte.class.equals((Object)fieldType) && !Byte.TYPE.equals(fieldType)) {
                if (!Boolean.class.equals((Object)fieldType) && !Boolean.TYPE.equals(fieldType)) {
                    if (String.class.equals((Object)fieldType)) {
                        return value;
                    }
                    if (!Short.class.equals((Object)fieldType) && !Short.TYPE.equals(fieldType)) {
                        if (!Integer.class.equals((Object)fieldType) && !Integer.TYPE.equals(fieldType)) {
                            if (!Long.class.equals((Object)fieldType) && !Long.TYPE.equals(fieldType)) {
                                if (!Float.class.equals((Object)fieldType) && !Float.TYPE.equals(fieldType)) {
                                    if (!Double.class.equals((Object)fieldType) && !Double.TYPE.equals(fieldType)) {
                                        if (Date.class.equals((Object)fieldType)) {
                                            return FieldReflectionUtil.parseDate(apiRequestParam, value);
                                        }
                                        throw new RuntimeException("request illeagal type, type must be Integer not int Long not long etc, type=" + fieldType);
                                    }
                                    return FieldReflectionUtil.parseDouble(value);
                                }
                                return FieldReflectionUtil.parseFloat(value);
                            }
                            return FieldReflectionUtil.parseLong(value);
                        }
                        return FieldReflectionUtil.parseInt(value);
                    }
                    return FieldReflectionUtil.parseShort(value);
                }
                return FieldReflectionUtil.parseBoolean(value);
            }
            return FieldReflectionUtil.parseByte(value);
        }
        return null;
    }
}

