/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.ThreadedRefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.core.enums.CharSetEnum;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtil {
    public static final Logger logger = LoggerFactory.getLogger(HttpRequestUtil.class);

    public static String getWebProtocol(String domainPath, String param) {
        String domainPath_ = "://";
        if (domainPath.isEmpty()) {
            return null;
        }
        if (domainPath.indexOf("://") >= 1) {
            return domainPath.substring(0, domainPath.indexOf("://") + 3);
        }
        String httpUrl = "http://" + domainPath + param;
        String httpsUrl = "https://" + domainPath + param;
        WebClient webClient = new WebClient(BrowserVersion.CHROME);
        webClient.getOptions().setTimeout(20000);
        webClient.setRefreshHandler((RefreshHandler)new ThreadedRefreshHandler());
        webClient.getCookieManager().setCookiesEnabled(false);
        webClient.getOptions().setThrowExceptionOnScriptError(false);
        webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        webClient.getOptions().setRedirectEnabled(true);
        webClient.getOptions().setCssEnabled(false);
        webClient.getOptions().setJavaScriptEnabled(false);
        webClient.getOptions().setUseInsecureSSL(true);
        webClient.setJavaScriptTimeout(20000L);
        try {
            Page page = webClient.getPage(httpUrl);
            String protocolName = page.getUrl().getProtocol();
            if (page.getWebResponse().getStatusCode() == 502 || protocolName == null) {
                protocolName = webClient.getPage(httpsUrl).getUrl().getProtocol();
                if (protocolName == null) {
                    return null;
                }
                return protocolName + "://";
            }
            return protocolName + "://";
        }
        catch (Exception e) {
            XxlJobLogger.log((String)e.toString(), (Object[])new Object[0]);
            try {
                String protocolName = webClient.getPage(httpsUrl).getUrl().getProtocol();
                return protocolName + "://";
            }
            catch (Exception ioException) {
                XxlJobLogger.log((String)e.toString(), (Object[])new Object[0]);
                return null;
            }
        }
    }

    public static String getProtocol(String domainPath, String param) {
        String domainPath_ = "://";
        if (domainPath.isEmpty()) {
            return null;
        }
        if (domainPath.indexOf("://") >= 1) {
            return domainPath.substring(0, domainPath.indexOf("://") + 3);
        }
        String httpUrl = "http://" + domainPath + param;
        String httpsUrl = "https://" + domainPath + param;
        WebClient webClient = new WebClient(BrowserVersion.CHROME);
        webClient.getOptions().setTimeout(20000);
        webClient.setRefreshHandler((RefreshHandler)new ThreadedRefreshHandler());
        webClient.getCookieManager().setCookiesEnabled(false);
        webClient.getOptions().setThrowExceptionOnScriptError(false);
        webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        webClient.getOptions().setRedirectEnabled(true);
        webClient.getOptions().setCssEnabled(false);
        webClient.getOptions().setJavaScriptEnabled(false);
        webClient.getOptions().setUseInsecureSSL(true);
        webClient.setJavaScriptTimeout(20000L);
        try {
            Page page = webClient.getPage(httpsUrl);
            String protocolName = page.getUrl().getProtocol();
            if (page.getWebResponse().getStatusCode() == 502 || protocolName == null) {
                protocolName = webClient.getPage(httpUrl).getUrl().getProtocol();
                if (protocolName == null) {
                    return null;
                }
                return protocolName + "://";
            }
            return protocolName + "://";
        }
        catch (Exception e) {
            XxlJobLogger.log((String)e.toString(), (Object[])new Object[0]);
            try {
                String protocolName = webClient.getPage(httpsUrl).getUrl().getProtocol();
                return protocolName + "://";
            }
            catch (Exception ioException) {
                XxlJobLogger.log((String)e.toString(), (Object[])new Object[0]);
                return null;
            }
        }
    }

    public static String get(String url, Map<String, String> headerMap) {
        String result = "";
        HttpGet get = new HttpGet(url);
        for (Map.Entry<String, String> stringStringEntry : headerMap.entrySet()) {
            get.addHeader(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            result = HttpRequestUtil.getHttpEntityContent((HttpResponse)response);
            if (response.getStatusLine().getStatusCode() != 200) {
                result = "\u670d\u52a1\u5668\u5f02\u5e38";
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u8bf7\u6c42\u5f02\u5e38", (Object[])new Object[0]);
            throw new RuntimeException(e);
        }
        finally {
            get.abort();
        }
        return result;
    }

    public static String get(Map<String, String> paramMap, String url, Map<String, String> headerMap) {
        String result = "";
        HttpGet get = new HttpGet(url);
        for (Map.Entry<String, String> stringStringEntry : headerMap.entrySet()) {
            get.addHeader(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            List<NameValuePair> params = HttpRequestUtil.setHttpParams(paramMap);
            String param = URLEncodedUtils.format(params, (String)CharSetEnum.UTF8.getCharSet());
            get.setURI(URI.create(url + "?" + param));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            result = HttpRequestUtil.getHttpEntityContent((HttpResponse)response);
            if (response.getStatusLine().getStatusCode() != 200) {
                result = "\u670d\u52a1\u5668\u5f02\u5e38";
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u8bf7\u6c42\u5f02\u5e38", (Object[])new Object[0]);
            throw new RuntimeException(e);
        }
        finally {
            get.abort();
        }
        return result;
    }

    public static List<NameValuePair> setHttpParams(Map<String, String> paramMap) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        Set<Map.Entry<String, String>> set = paramMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            params.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return params;
    }

    public static String getHttpEntityContent(HttpResponse response) throws UnsupportedOperationException, IOException {
        String result = "";
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream in = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, CharSetEnum.UTF8.getCharSet()));
            StringBuilder strber = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                strber.append(line + '\n');
            }
            br.close();
            in.close();
            result = strber.toString();
        }
        return result;
    }

    public static String getWebProtocol(String domainPath, String param, String defultProtocol) {
        String protocol = HttpRequestUtil.getWebProtocol(domainPath, param);
        if (protocol == null) {
            return defultProtocol;
        }
        return protocol;
    }
}

