/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import com.xforceplus.utils.DigestLib;
import com.xforceplus.utils.FileUtils;
import com.xforceplus.utils.JsonLib;
import com.xforceplus.utils.StringLib;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.springframework.core.env.Environment;

public class JavaScriptUtils {
    private static final Pattern SingleLineCommentPattern = Pattern.compile("/\\/\\*[\\s\\S]*?\\*\\/|([^\\\\:]|^)\\/\\/.*|<!--[\\s\\S]*?-->$/");
    private static final Pattern MultipleLineCommentPattern = Pattern.compile("/\\*([^*]|[\\r\\n]|(\\*+([^*/]|[\\r\\n])))*\\*+/");
    private static Cache<String, Object> compiledScriptCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private static ScriptEngineManager manager = new ScriptEngineManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MutablePair<Object, String> runAsFunc(String code, Map<String, Object> params) {
        MutablePair pair = new MutablePair();
        ArrayList paramNameList = Lists.newArrayList(params.keySet());
        Collections.sort(paramNameList);
        String codeMD5 = DigestLib.md5Hex((String)StringLib.join((Object[])new String[]{" ", code, " ", StringLib.join((Iterable)paramNameList, (String)" ")}));
        NashornScriptEngine nashornScriptEngine = (NashornScriptEngine)compiledScriptCache.getIfPresent((Object)codeMD5);
        String functionName = StringLib.join((Object[])new String[]{"func_", codeMD5});
        Object returnValue = null;
        try {
            Object runCode;
            if (nashornScriptEngine == null) {
                nashornScriptEngine = JavaScriptUtils.getScriptEngine();
                runCode = StringLib.join((Object[])new String[]{"function ", functionName, "(", StringLib.join((Iterable)paramNameList, (String)","), "){", code, "}"});
                nashornScriptEngine.eval((String)runCode);
                compiledScriptCache.put((Object)codeMD5, (Object)nashornScriptEngine);
            }
            runCode = nashornScriptEngine;
            synchronized (runCode) {
                ArrayList valueList = Lists.newArrayList();
                paramNameList.stream().forEach(paramName -> valueList.add(params.get(paramName)));
                returnValue = nashornScriptEngine.invokeFunction(functionName, valueList.toArray());
            }
            if (returnValue != null) {
                if (returnValue instanceof ScriptObjectMirror) {
                    ScriptObjectMirror mirror = (ScriptObjectMirror)returnValue;
                    if (mirror.isArray()) {
                        JavaScriptUtils.recursionEencapsulation(mirror);
                        pair.setLeft((Object)JsonLib.toJSON(mirror.to(List.class)));
                    } else {
                        JavaScriptUtils.recursionEencapsulation(mirror);
                        pair.setLeft((Object)JsonLib.toJSON(mirror));
                    }
                } else if (returnValue instanceof ArrayList) {
                    pair.setLeft((Object)JsonLib.toJSON(returnValue, List.class, new String[0]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pair.setRight((Object)e.getMessage());
        }
        if (pair.getLeft() == null) {
            pair.setLeft(returnValue);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runAsFunc2(String code, Map<String, Object> params) {
        ArrayList paramNameList = Lists.newArrayList(params.keySet());
        Collections.sort(paramNameList);
        String codeMD5 = DigestLib.md5Hex((String)StringLib.join((Object[])new String[]{" ", code, " ", StringLib.join((Iterable)paramNameList, (String)" ")}));
        NashornScriptEngine nashornScriptEngine = (NashornScriptEngine)compiledScriptCache.getIfPresent((Object)codeMD5);
        String functionName = StringLib.join((Object[])new String[]{"func_", codeMD5});
        Object returnValue = null;
        try {
            Object runCode;
            if (nashornScriptEngine == null) {
                nashornScriptEngine = JavaScriptUtils.getScriptEngine();
                runCode = StringLib.join((Object[])new String[]{"function ", functionName, "(", StringLib.join((Iterable)paramNameList, (String)","), "){", code, "}"});
                nashornScriptEngine.eval((String)runCode);
                compiledScriptCache.put((Object)codeMD5, (Object)nashornScriptEngine);
            }
            runCode = nashornScriptEngine;
            synchronized (runCode) {
                ArrayList valueList = Lists.newArrayList();
                paramNameList.stream().forEach(paramName -> valueList.add(params.get(paramName)));
                returnValue = nashornScriptEngine.invokeFunction(functionName, valueList.toArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList doo = new ArrayList();
        ScriptObjectMirror som = (ScriptObjectMirror)returnValue;
        Set entries = som.entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            if (value instanceof ScriptObjectMirror) {
                ScriptObjectMirror so = (ScriptObjectMirror)value;
                JSONObject document = new JSONObject();
                for (Map.Entry se : so.entrySet()) {
                    document.put((String)se.getKey(), se.getValue());
                }
                value = document;
            }
            doo.add(value);
        }
        return doo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MutablePair<Object, String> runAsFunc1(String code, Map<String, Object> params) {
        MutablePair pair = new MutablePair();
        String codeMD5 = DigestLib.md5Hex((String)StringLib.join((Object[])new String[]{code, "data1"}));
        NashornScriptEngine nashornScriptEngine = (NashornScriptEngine)compiledScriptCache.getIfPresent((Object)codeMD5);
        String functionName = StringLib.join((Object[])new String[]{"func_", codeMD5});
        Object returnValue = null;
        try {
            Object runCode;
            if (nashornScriptEngine == null) {
                nashornScriptEngine = JavaScriptUtils.getScriptEngine();
                runCode = StringLib.join((Object[])new String[]{"function ", functionName, "(data1){ ", code, " }"});
                nashornScriptEngine.eval((String)runCode);
                compiledScriptCache.put((Object)codeMD5, (Object)nashornScriptEngine);
            }
            runCode = nashornScriptEngine;
            synchronized (runCode) {
                returnValue = nashornScriptEngine.invokeFunction(functionName, new Object[]{params});
            }
            if (returnValue != null) {
                if (returnValue instanceof ScriptObjectMirror) {
                    ScriptObjectMirror mirror = (ScriptObjectMirror)returnValue;
                    if (mirror.isArray()) {
                        pair.setLeft((Object)JsonLib.toJSON(mirror.to(List.class)));
                    } else {
                        pair.setLeft((Object)JsonLib.toJSON(mirror));
                    }
                } else if (returnValue instanceof ArrayList) {
                    pair.setLeft((Object)JsonLib.toJSON(returnValue, List.class, new String[0]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pair.setRight((Object)e.getMessage());
        }
        if (pair.getLeft() == null) {
            pair.setLeft(returnValue);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MutablePair<Object, String> runAsFunc3(String code, Map<String, Object> params) {
        MutablePair pair = new MutablePair();
        ArrayList paramNameList = Lists.newArrayList(params.keySet());
        Collections.sort(paramNameList);
        String codeMD5 = DigestLib.md5Hex((String)StringLib.join((Object[])new String[]{" ", code, " ", StringLib.join((Iterable)paramNameList, (String)" ")}));
        NashornScriptEngine nashornScriptEngine = (NashornScriptEngine)compiledScriptCache.getIfPresent((Object)codeMD5);
        String functionName = StringLib.join((Object[])new String[]{"func_", codeMD5});
        Object returnValue = null;
        try {
            Object runCode;
            if (nashornScriptEngine == null) {
                nashornScriptEngine = JavaScriptUtils.getScriptEngine();
                runCode = StringLib.join((Object[])new String[]{"function ", functionName, "(", StringLib.join((Iterable)paramNameList, (String)","), "){", code, "}"});
                nashornScriptEngine.eval((String)runCode);
                compiledScriptCache.put((Object)codeMD5, (Object)nashornScriptEngine);
            }
            runCode = nashornScriptEngine;
            synchronized (runCode) {
                ArrayList valueList = Lists.newArrayList();
                paramNameList.stream().forEach(paramName -> valueList.add(params.get(paramName)));
                returnValue = nashornScriptEngine.invokeFunction(functionName, valueList.toArray());
            }
            if (returnValue != null) {
                pair.setLeft(returnValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pair.setRight((Object)e.getMessage());
        }
        return pair;
    }

    public static String formatCode(String code) {
        if (StringLib.isNotEmpty((CharSequence)code)) {
            code = RegExUtils.replaceAll((String)code, (Pattern)SingleLineCommentPattern, (String)"");
            code = RegExUtils.replaceAll((String)code, (Pattern)MultipleLineCommentPattern, (String)"");
            code = StringLib.replace((String)code, (String)"\n", (String)"");
            code = StringLib.replace((String)code, (String)"\r", (String)"");
            return code;
        }
        return code;
    }

    private static boolean isDebug() {
        Environment environment = (Environment)SpringUtil.getBean(Environment.class);
        boolean debug = StringLib.equals((CharSequence)environment.getProperty("debug"), (CharSequence)"true");
        return debug;
    }

    private static String loadLodashJs() {
        String loDashFilePath = "js/lodash/lodash.min.js";
        if (JavaScriptUtils.isDebug()) {
            loDashFilePath = "js/lodash/lodash.js";
        }
        return FileUtils.readClassPathFileContent(loDashFilePath);
    }

    private static NashornScriptEngine getScriptEngine() {
        NashornScriptEngine scriptEngine = (NashornScriptEngine)manager.getEngineByName("nashorn");
        String lodash = JavaScriptUtils.loadLodashJs();
        if (StringLib.isNotEmpty((CharSequence)lodash)) {
            try {
                scriptEngine.eval(lodash);
                StringBuffer buffer = new StringBuffer();
                buffer.append("function toFloat(value) {if(value){value = parseFloat(value);if(_.isNaN(value)){value = 0.0;}return value;}return 0.0;}");
                buffer.append("function valueDiff(row,newKey,key1,key2){var value1 = toFloat(_.get(row,key1,0));var value2 = toFloat(_.get(row,key2,0));_.set(row,newKey,value1 - value2);}");
                buffer.append("function dayOfWeek(){var week = new Date().getDay();if (week == 0) {return '\u65e5';} else if (week == 1) {return '\u4e00';} else if (week == 2) {return '\u4e8c';} else if (week == 3) {return '\u4e09';} else if (week == 4) {return '\u56db';} else if (week == 5) {return '\u4e94';} else if (week == 6) {return '\u516d';}return '';}");
                buffer.append("function offsetDay(datestr,offset){var date = new Date(datestr);var result=new Date((date/1000+(86400*offset))*1000);var resultStr=result.getFullYear()+'-'+(result.getMonth()+1)+'-'+(result.getDate());return resultStr;}");
                buffer.append("function betweenDay(beginstr,endstr){var startTime = new Date(Date.parse(beginstr.replace(/-/g, \"/\"))).getTime();var endTime = new Date(Date.parse(endstr.replace(/-/g, \"/\"))).getTime();var dates = Math.abs((startTime - endTime))/(1000*60*60*24);return dates;}");
                scriptEngine.eval(buffer.toString());
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
        return scriptEngine;
    }

    public static void recursionEencapsulation(ScriptObjectMirror scriptObject) {
        for (String key : scriptObject.keySet()) {
            if (!(scriptObject.get((Object)key) instanceof ScriptObjectMirror)) continue;
            ScriptObjectMirror mirror = (ScriptObjectMirror)scriptObject.get((Object)key);
            JavaScriptUtils.recursionEencapsulation(mirror);
            Boolean isArray = JavaScriptUtils.isArray(mirror);
            if (!isArray.booleanValue()) continue;
            List<Object> list = JavaScriptUtils.parseArray(mirror);
            scriptObject.put(key, list);
        }
    }

    public static Boolean isArray(ScriptObjectMirror scriptObject) {
        boolean isArray = true;
        int index = 0;
        for (String key : scriptObject.keySet()) {
            if (!key.equals(index + "")) {
                isArray = false;
            }
            ++index;
        }
        return isArray;
    }

    public static List<Object> parseArray(ScriptObjectMirror scriptObject) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String key : scriptObject.keySet()) {
            Object obj = scriptObject.get((Object)key);
            arrayList.add(obj);
        }
        return arrayList;
    }
}

