/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.account.cache;

import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.account.AbstractLoginSys;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.core.enums.IntConstant;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.utils.FileUtil;
import com.xforceplus.utils.SpringContext;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.springframework.util.DigestUtils;

public class LoginFileCache {
    private static final String LOGIN_KEY_PREFIX = "dcs:login:key:";
    private static final String LOGIN_KEY_RPA_PREFIX = "dcs:login:key:rpa:";
    private static final String LOGIN_CACHE_PREFIX = "dcs:login:cache:";
    private static final String LOGIN_CACHE_RPA_PREFIX = "dcs:login:cache:rpa:";
    private static final RedissonLock redissonLock = SpringContext.getBean(RedissonLock.class);
    private static final String fileName = "webClient.dat";
    private static volatile LoginFileCache instance = null;

    private LoginFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoginFileCache getInstance() {
        if (instance != null) return instance;
        Class<LoginFileCache> clazz = LoginFileCache.class;
        synchronized (LoginFileCache.class) {
            if (instance != null) return instance;
            instance = new LoginFileCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public WebClient get(AccountTemplateDO account) {
        RBucket bucket = redissonLock.getRedissonManager().getRedisson().getBucket(this.getCacheKey(account));
        if (bucket.get() == null) {
            return null;
        }
        return (WebClient)this.deserialFromFile(account);
    }

    public void delLoginCache(AccountTemplateDO account) {
        RBucket bucket = redissonLock.getRedissonManager().getRedisson().getBucket(this.getCacheKey(account));
        if (bucket.get() != null) {
            XxlJobLogger.log((String)"\u5220\u9664redis\u7f13\u5b58\u4fe1\u606f...", (Object[])new Object[0]);
            bucket.delete();
        }
    }

    public void put(WebClient webClient, AccountTemplateDO account) {
        this.serialToFile(webClient, account);
    }

    private void serialToFile(WebClient webClient, AccountTemplateDO account) {
        String filePath = this.getFilePath(account);
        try {
            FileUtil.createDir(filePath);
            FileOutputStream outStream = new FileOutputStream(filePath.concat(File.separator).concat(fileName));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outStream);
            objectOutputStream.writeObject(webClient);
            objectOutputStream.flush();
            outStream.close();
            objectOutputStream.close();
            XxlJobLogger.log((String)"\u767b\u5f55\u7f13\u5b58\u6587\u4ef6\u5199\u5165\u6210\u529f!\u8def\u5f84->{}", (Object[])new Object[]{filePath});
        }
        catch (IOException ex) {
            XxlJobLogger.log((String)"\u767b\u5f55\u7f13\u5b58\u6587\u4ef6\u5199\u5165\u5931\u8d25!\u8def\u5f84->{}", (Object[])new Object[]{filePath});
        }
    }

    private <T> T deserialFromFile(AccountTemplateDO account) {
        try {
            String filePath = this.getFilePath(account);
            File file = new File(filePath.concat(File.separator).concat(fileName));
            if (!file.exists()) {
                return null;
            }
            FileInputStream inputStream = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(inputStream);
            Object object = ois.readObject();
            inputStream.close();
            ois.close();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getFilePath(AccountTemplateDO account) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String area = account.getArea();
        if (StringUtils.isNotBlank((CharSequence)area)) {
            area = DigestUtils.md5DigestAsHex((byte[])area.getBytes());
            accountName = accountName + File.separator + area;
        }
        return CommonConfig.DCS_FILE_ROOT_PATH + File.separator + "loginCache" + File.separator + projectKey + File.separator + retailKey + File.separator + accountName;
    }

    public String getLockKey(AccountTemplateDO account) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String area = account.getArea();
        if (StringUtils.isNotBlank((CharSequence)area)) {
            area = DigestUtils.md5DigestAsHex((byte[])area.getBytes());
            accountName = accountName + "-" + area;
        }
        return LOGIN_KEY_PREFIX + projectKey + "-" + retailKey + "-" + accountName;
    }

    public String getRpaAccountLockKey(AccountTemplateDO account) {
        String accountName = account.getAccountName();
        return LOGIN_KEY_RPA_PREFIX + accountName;
    }

    public String getCacheKey(AccountTemplateDO account) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String area = account.getArea();
        if (StringUtils.isNotBlank((CharSequence)area)) {
            area = DigestUtils.md5DigestAsHex((byte[])area.getBytes());
            accountName = accountName + "-" + area;
        }
        return LOGIN_CACHE_PREFIX + projectKey + "-" + retailKey + "-" + accountName;
    }

    public String getRpaCacheKey(AccountTemplateDO account) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String enterpriseId = account.getEnterpriseId();
        if (StringUtils.isNotBlank((CharSequence)enterpriseId)) {
            accountName = accountName + "-" + enterpriseId;
        }
        return LOGIN_CACHE_RPA_PREFIX + projectKey + "-" + retailKey + "-" + accountName;
    }

    public WebClient login(AbstractLoginSys loginSys, AccountTemplateDO account, Map<String, String> contextMap) throws IOException {
        WebClient webClient;
        XxlJobLogger.log((String)"\u6267\u884c\u767b\u5f55\u64cd\u4f5c...", (Object[])new Object[0]);
        String lockKey = this.getLockKey(account);
        boolean lock = redissonLock.lock(lockKey, IntConstant.SIXTY);
        if (lock) {
            webClient = this.get(account);
            if (webClient == null) {
                webClient = loginSys.login(account, contextMap);
                if (webClient != null) {
                    this.put(webClient, account);
                    RBucket bucket = redissonLock.getRedissonManager().getRedisson().getBucket(this.getCacheKey(account));
                    bucket.set((Object)1);
                    bucket.expire((long)account.getWebClientExpireTime().intValue(), TimeUnit.MINUTES);
                }
            } else {
                XxlJobLogger.log((String)"\u53d1\u73b0\u7f13\u5b58\u5df2\u7ecf\u5b58\u5728,\u76f4\u63a5\u4f7f\u7528\u7f13\u5b58...", (Object[])new Object[0]);
            }
            redissonLock.release(lockKey);
        } else {
            boolean bool = redissonLock.isLock(lockKey);
            for (int i = 0; i < 10 && bool; ++i) {
                try {
                    Thread.sleep(15000L);
                    bool = redissonLock.isLock(lockKey);
                    continue;
                }
                catch (InterruptedException e) {
                    XxlJobLogger.log((String)"\u91c7\u96c6\u767b\u5f55\u7f13\u5b58\u52a0\u9501\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u9501{}\u60c5\u51b5", (Object[])new Object[]{lockKey});
                    return null;
                }
            }
            if (bool) {
                XxlJobLogger.log((String)"\u91c7\u96c6\u767b\u5f55\u7f13\u5b58\u52a0\u9501\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u9501{}\u60c5\u51b5", (Object[])new Object[]{lockKey});
                return null;
            }
            XxlJobLogger.log((String)"\u5f53\u524d\u88ab\u5176\u4ed6\u7ebf\u7a0b\u62a2\u5360\u767b\u5f55\u64cd\u4f5c,\u7b49\u5f85\u5176\u4ed6\u7ebf\u7a0b\u91ca\u653e\u767b\u5f55\u9501\u540e,\u91cd\u65b0\u83b7\u53d6\u7f13\u5b58,\u76f4\u63a5\u4f7f\u7528...", (Object[])new Object[0]);
            webClient = (WebClient)this.deserialFromFile(account);
        }
        return webClient;
    }
}

