/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.account.cache;

import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.utils.FileUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Cookie;
import org.springframework.util.DigestUtils;

public class LoginRpaFileCache {
    private static final String fileName = "rpa.dat";
    private static volatile LoginRpaFileCache instance = null;

    private LoginRpaFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoginRpaFileCache getInstance() {
        if (instance != null) return instance;
        Class<LoginRpaFileCache> clazz = LoginRpaFileCache.class;
        synchronized (LoginRpaFileCache.class) {
            if (instance != null) return instance;
            instance = new LoginRpaFileCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void put(Set<Cookie> cookies, AccountTemplateDO account) {
        this.serialToFile(cookies, account);
    }

    private void serialToFile(Set<Cookie> cookies, AccountTemplateDO account) {
        String filePath = this.getFilePath(account);
        try {
            FileUtil.createDir(filePath);
            FileOutputStream outStream = new FileOutputStream(filePath.concat(File.separator).concat(fileName));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outStream);
            objectOutputStream.writeObject(cookies);
            objectOutputStream.flush();
            outStream.close();
            objectOutputStream.close();
            XxlJobLogger.log((String)"\u767b\u5f55\u7f13\u5b58\u6587\u4ef6\u5199\u5165\u6210\u529f!\u8def\u5f84->{}", (Object[])new Object[]{filePath});
        }
        catch (IOException ex) {
            XxlJobLogger.log((String)"\u767b\u5f55\u7f13\u5b58\u6587\u4ef6\u5199\u5165\u5931\u8d25!\u8def\u5f84->{}", (Object[])new Object[]{filePath});
        }
    }

    public Set<Cookie> get(AccountTemplateDO account) {
        return (Set)this.deserialFromFile(account);
    }

    public <T> T deserialFromFile(AccountTemplateDO account) {
        try {
            String filePath = this.getFilePath(account);
            File file = new File(filePath.concat(File.separator).concat(fileName));
            if (!file.exists()) {
                return null;
            }
            FileInputStream inputStream = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(inputStream);
            Object object = ois.readObject();
            inputStream.close();
            ois.close();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getFilePath(AccountTemplateDO account) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String area = account.getArea();
        if (StringUtils.isNotBlank((CharSequence)area)) {
            area = DigestUtils.md5DigestAsHex((byte[])area.getBytes());
            accountName = accountName + File.separator + area;
        }
        return CommonConfig.DCS_FILE_ROOT_PATH + File.separator + "loginCache" + File.separator + projectKey + File.separator + retailKey + File.separator + accountName;
    }
}

