/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.core.notice.ExceptionDdNoticer;
import com.xforceplus.janus.config.core.config.ActionConfig;
import com.xforceplus.janus.config.core.config.ConfigHttpBuilder;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.utils.BaseUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class CustomRunListener
implements SpringApplicationRunListener {
    private static final Logger log = LoggerFactory.getLogger(CustomRunListener.class);
    private static boolean isIngoreRemote = false;

    public CustomRunListener(SpringApplication application, String[] args) {
    }

    public void starting() {
        log.info("Spring Boot Application Starting");
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        log.info("Spring Boot Application environmentPrepared");
        boolean bl = isIngoreRemote = !StringUtils.isBlank((CharSequence)environment.getProperty("janus.cloud.config")) && Objects.equals(environment.getProperty("janus.cloud.config"), "false");
        if (isIngoreRemote) {
            return;
        }
        HttpConfig config = new HttpConfig();
        config.setUrl(environment.getProperty("janus.url"));
        config.setAuthentication(environment.getProperty("janus.authentication"));
        ActionConfig actionConfig = new ActionConfig();
        actionConfig.setConfig(environment.getProperty("janus.action.config"));
        config.setAction(actionConfig);
        ConfigHttpBuilder configHttpBuilder = new ConfigHttpBuilder(config);
        String body = configHttpBuilder.buildConfig();
        if (StringUtils.isNotBlank((CharSequence)body)) {
            this.initConfig(body, environment);
        }
        this.startLoadRemoteConfig(environment);
        try {
            ExceptionDdNoticer.APP_NAME = environment.getProperty("dd.ddAppName", environment.getProperty("spring.application.name", ""));
            ExceptionDdNoticer.APP_ENV = environment.getProperty("spring.profiles.active", "");
            BaseUtils.JANUS_URL = environment.getProperty("janus.url", "");
            BaseUtils.IP_PROXY_ACTION = environment.getProperty("janus.action.proxy", "");
            BaseUtils.JANUS_TOKEN = environment.getProperty("janus.authentication", "");
            Conf.overProp((Properties)this.convert(environment));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Properties convert(ConfigurableEnvironment environment) {
        Properties properties = new Properties();
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (!(propertySource.getSource() instanceof Map)) continue;
            Map map = (Map)propertySource.getSource();
            properties.putAll((Map<?, ?>)map);
        }
        return properties;
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void started(ConfigurableApplicationContext context) {
    }

    public void running(ConfigurableApplicationContext context) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }

    private void startLoadRemoteConfig(ConfigurableEnvironment environment) {
        new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(310000L);
                        if (isIngoreRemote) continue;
                        this.loadConfig(environment);
                    }
                }
                catch (Exception ex) {
                    log.error("\u52a0\u8f7d\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u5f02\u5e38", (Throwable)ex);
                    continue;
                }
                break;
            }
        }).start();
    }

    private void loadConfig(ConfigurableEnvironment environment) {
        try {
            Class<HttpConfig> clazz = HttpConfig.class;
            Field field = clazz.getDeclaredField("CONFIGS");
            field.setAccessible(true);
            Map configs = (Map)field.get(null);
            if (MapUtils.isNotEmpty((Map)configs)) {
                Properties props = new Properties();
                for (String key : configs.keySet()) {
                    props.put(key, configs.get(key));
                }
                PropertiesPropertySource propertySource = new PropertiesPropertySource("custom_dy_cfs", props);
                environment.getPropertySources().addFirst((PropertySource)propertySource);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private void initConfig(String body, ConfigurableEnvironment environment) {
        Map allConfigs = (Map)JacksonUtil.getInstance().fromJson(body, HashMap.class);
        if (MapUtils.isNotEmpty((Map)allConfigs)) {
            Properties props = new Properties();
            props.put("management.endpoints.web.exposure.include", "info,prometheus");
            props.put("management.endpoints.web.base-path", "/");
            props.put("management.endpoint.prometheus.enabled", "true");
            for (String key : allConfigs.keySet()) {
                props.put(key, allConfigs.get(key));
            }
            PropertiesPropertySource propertySource = new PropertiesPropertySource("custom_dy_cfs", props);
            environment.getPropertySources().addFirst((PropertySource)propertySource);
        }
    }
}

