/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.enums;

import com.xforceplus.core.enums.RetailConstantEnum;
import java.util.LinkedHashMap;
import java.util.Map;

public enum RetailAreaEnum {
    EASTCHINA(1, "1", "\u534e\u4e1c", RetailConstantEnum.RTMART.getKey()),
    NORTHCHINA(2, "2", "\u534e\u5317", RetailConstantEnum.RTMART.getKey()),
    NORTHEAST(3, "3", "\u4e1c\u5317", RetailConstantEnum.RTMART.getKey()),
    CENTRALCHINA(4, "4", "\u534e\u4e2d", RetailConstantEnum.RTMART.getKey()),
    SOUTHCHINA(5, "5", "\u534e\u5357", RetailConstantEnum.RTMART.getKey()),
    WUMART(6, "300", "\u7269\u7f8e", RetailConstantEnum.WUMART.getKey()),
    NEWBAI(7, "307", "\u65b0\u534e\u767e\u8d27", RetailConstantEnum.XHBH.getKey());

    private final int index;
    private final String areaValue;
    private final String areaName;
    private final String retailEnumKey;
    private static final Map<String, String> RETAILAREAENUM_KEY;

    private RetailAreaEnum(int index, String areaValue, String areaName, String retailEnumKey) {
        this.index = index;
        this.areaValue = areaValue;
        this.areaName = areaName;
        this.retailEnumKey = retailEnumKey;
    }

    public static boolean isNotNullByArea(String areaValue, String retailEnumKey) {
        if (areaValue == null || retailEnumKey == null) {
            return false;
        }
        if (areaValue.trim().length() == 0 || retailEnumKey.trim().length() == 0) {
            return false;
        }
        return RETAILAREAENUM_KEY.get(areaValue.concat(retailEnumKey)) != null;
    }

    public static String getValueByEnumkey(String RetailConstantEnumKey) {
        return RETAILAREAENUM_KEY.get(RetailConstantEnumKey);
    }

    public int getIndex() {
        return this.index;
    }

    public String getAreaValue() {
        return this.areaValue;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getRetailEnumKey() {
        return this.retailEnumKey;
    }

    public static void main(String[] args) {
        System.out.println("--------------" + RetailAreaEnum.isNotNullByArea("23", RetailConstantEnum.RTMART.getKey()));
    }

    static {
        RETAILAREAENUM_KEY = new LinkedHashMap<String, String>();
        for (RetailAreaEnum area : RetailAreaEnum.values()) {
            RETAILAREAENUM_KEY.put(area.areaValue.concat(area.retailEnumKey), area.areaName);
        }
    }
}

