/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.notice;

import com.xforceplus.apollo.utils.DateFormatUtil;
import com.xforceplus.core.notice.LogAssistWrapper;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class ExceptionDdNoticer {
    private static String LOG_ERROE_LEVEL = "ERROR";
    public static String APP_ENV = "";
    public static String APP_NAME = "";

    public static void loggerError(Logger logger, String format, Object ... arr) {
        String logMsg = ExceptionDdNoticer.info(LOG_ERROE_LEVEL, format, arr);
        logger.error(logMsg);
        LogAssistWrapper.doHoldData(logMsg);
    }

    public static void loggerError(Logger logger, String content) {
        String logMsg = ExceptionDdNoticer.info(LOG_ERROE_LEVEL, content, null);
        logger.error(logMsg);
        LogAssistWrapper.doHoldData(logMsg);
    }

    private static String info(String level, String format, Object ... arr) {
        StackTraceElement[] temp = Thread.currentThread().getStackTrace();
        StackTraceElement method = temp[temp.length - 1];
        StringBuilder sb = new StringBuilder(10240);
        sb.append(DateFormatUtil.getCurrentFormatDateTime());
        sb.append(" [").append(level).append("] ");
        sb.append("[").append(APP_ENV + "-" + APP_NAME).append("] ");
        sb.append("[").append(Thread.currentThread().getName()).append("-").append(Thread.currentThread().getId()).append("] ");
        sb.append("[").append(method.getClassName());
        sb.append("-").append(method.getMethodName()).append("-");
        sb.append(method.getLineNumber()).append("] ");
        if (null != arr && arr.length >= 1) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = "[" + arr[i] + "]";
            }
            sb.append(ExceptionDdNoticer.logMsgPackage(format, arr));
        } else {
            sb.append(format);
        }
        return sb.toString();
    }

    private static String logMsgPackage(String format, Object ... arr) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])arr);
        return null == ft ? format : ft.getMessage();
    }
}

