/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.notice;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.core.notice.DdingNoticeHelper;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAssistWrapper {
    private static final Logger logger = LoggerFactory.getLogger(LogAssistWrapper.class);
    private static AtomicBoolean init = new AtomicBoolean(false);
    private static ExecutorService executorService = Executors.newFixedThreadPool(1);
    private static AtomicBoolean running = new AtomicBoolean(false);
    private static BlockingQueue<String> queue = new LinkedBlockingQueue<String>(500);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (init.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = init;
        synchronized (atomicBoolean) {
            if (init.get()) {
                return;
            }
            if (!running.get()) {
                LogAssistWrapper.start();
            }
            init.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() {
        AtomicBoolean atomicBoolean = running;
        synchronized (atomicBoolean) {
            if (running.get()) {
                return;
            }
            running.set(true);
            executorService.execute(() -> {
                while (running.get()) {
                    try {
                        String item = queue.take();
                        DdingNoticeHelper.getInstance().sendDdingNotice(item);
                    }
                    catch (Exception e) {
                        logger.error(ErrorUtil.getStackMsg((Exception)e));
                    }
                    catch (Error error) {
                        logger.error(ErrorUtil.getStackMsg((Throwable)error));
                    }
                }
            });
        }
    }

    public static void doHoldData(String message) {
        try {
            if (!init.get()) {
                LogAssistWrapper.init();
            }
            queue.offer(message, 200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.error(ErrorUtil.getStackMsg((Exception)e));
        }
    }
}

