/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.xforceplus.utils.StringLib;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class DataSourceExcelReadListener
extends AnalysisEventListener {
    private Table<Integer, Integer, String> excelDataTable = HashBasedTable.create();
    private AtomicInteger rowIndex = new AtomicInteger(0);

    public void reset() {
        if (this.excelDataTable != null) {
            this.excelDataTable.clear();
        }
        this.rowIndex = new AtomicInteger(0);
    }

    public Table<Integer, Integer, String> getTableData() {
        return this.excelDataTable;
    }

    public void invoke(Object o, AnalysisContext analysisContext) {
        HashMap hashMap = (HashMap)o;
        AtomicInteger rowValueSize = new AtomicInteger(0);
        Set colKeys = hashMap.keySet();
        colKeys.stream().forEach(colIdx -> {
            Object subitem = hashMap.get(colIdx);
            String strValue = StringLib.toString(subitem);
            strValue = StringLib.trim((String)strValue);
            rowValueSize.addAndGet(strValue.length());
            this.excelDataTable.put((Object)this.rowIndex.get(), colIdx, (Object)StringLib.toString(subitem));
        });
        if (rowValueSize.get() == 0) {
            this.excelDataTable.row((Object)this.rowIndex.get()).clear();
        }
        this.rowIndex.incrementAndGet();
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }
}

